/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.io.parser.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.tree.ParseTreeProperty;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.antlr.v4.runtime.tree.TerminalNode;
import uniol.apt.adt.exception.DatastructureException;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.io.parser.ParseException;
import uniol.apt.io.parser.Parser;
import uniol.apt.io.parser.impl.AbstractParser;
import uniol.apt.io.parser.impl.ParseRuntimeException;
import uniol.apt.io.parser.impl.PetrifyPNFormatLexer;
import uniol.apt.io.parser.impl.PetrifyPNFormatParser;
import uniol.apt.io.parser.impl.PetrifyPNFormatParserBaseListener;
import uniol.apt.io.parser.impl.PetrifyPNFormatParserListener;
import uniol.apt.io.parser.impl.ThrowingErrorListener;
import uniol.apt.util.Pair;

public class PetrifyPNParser
extends AbstractParser<PetriNet>
implements Parser<PetriNet> {
    public static final String FORMAT = "petrify";

    @Override
    public String getFormat() {
        return FORMAT;
    }

    @Override
    public List<String> getFileExtensions() {
        return Collections.unmodifiableList(Arrays.asList("g"));
    }

    @Override
    public PetriNet parse(InputStream is) throws ParseException, IOException {
        PetrifyPNFormatParser.PnContext tree;
        ANTLRInputStream input = new ANTLRInputStream(is);
        PetrifyPNFormatLexer lexer = new PetrifyPNFormatLexer(input);
        lexer.removeErrorListeners();
        lexer.addErrorListener(new ThrowingErrorListener());
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        PetrifyPNFormatParser parser = new PetrifyPNFormatParser(tokens);
        parser.removeErrorListeners();
        parser.addErrorListener(new ThrowingErrorListener());
        parser.setBuildParseTree(true);
        try {
            tree = parser.pn();
        }
        catch (ParseRuntimeException ex) {
            throw ex.getParseException();
        }
        PetriNet pn = new PetriNet();
        try {
            ParseTreeWalker.DEFAULT.walk(new PNListener(pn), tree);
        }
        catch (ParseRuntimeException ex) {
            throw ex.getParseException();
        }
        catch (DatastructureException ex) {
            throw new ParseException(ex.getMessage(), ex);
        }
        return pn;
    }

    private static class PNListener
    extends PetrifyPNFormatParserBaseListener
    implements PetrifyPNFormatParserListener {
        private final PetriNet pn;
        private final Map<Pair<String, String>, Place> implicitPlaces = new HashMap<Pair<String, String>, Place>();
        private final ParseTreeProperty<String> nodeIds = new ParseTreeProperty();

        private PNListener(PetriNet pn) {
            this.pn = pn;
        }

        @Override
        public void exitModel(PetrifyPNFormatParser.ModelContext ctx) {
            this.pn.setName(ctx.NAME().getText());
        }

        @Override
        public void exitTransitions(PetrifyPNFormatParser.TransitionsContext ctx) {
            for (TerminalNode event : ctx.ID()) {
                this.pn.createTransition(event.getText());
            }
        }

        @Override
        public void exitFlow(PetrifyPNFormatParser.FlowContext ctx) {
            String source = this.nodeIds.get(ctx.source);
            boolean sourceIsTransition = this.pn.containsTransition(source);
            if (!sourceIsTransition && !this.pn.containsPlace(source)) {
                this.pn.createPlace(source);
            }
            for (PetrifyPNFormatParser.Flow_targetContext targetCtx : ctx.flow_target()) {
                int weight = 1;
                if (targetCtx.INT() != null) {
                    weight = Integer.parseInt(targetCtx.INT().getText());
                }
                String target = this.nodeIds.get(targetCtx.event());
                if (sourceIsTransition && this.pn.containsTransition(target)) {
                    Pair<String, String> pair = new Pair<String, String>(source, target);
                    String placeName = "<" + source + "," + target + ">";
                    this.implicitPlaces.put(pair, this.pn.createPlace(placeName));
                    this.pn.createFlow(source, placeName, weight);
                    this.pn.createFlow(placeName, target, weight);
                    continue;
                }
                if (sourceIsTransition) {
                    if (!this.pn.containsPlace(target)) {
                        this.pn.createPlace(target);
                    }
                } else if (!this.pn.containsTransition(target)) {
                    throw new ParseRuntimeException("Tried to create arc between two places '" + source + "' and '" + target + "'");
                }
                this.pn.createFlow(source, target, weight);
            }
        }

        @Override
        public void exitTokenExplicitPlace(PetrifyPNFormatParser.TokenExplicitPlaceContext ctx) {
            Place p = this.pn.getPlace(ctx.ID().getText());
            if (p.getInitialToken().getValue() != 0L) {
                throw new ParseRuntimeException("Duplicate initial marking for place '" + p.getId() + "'");
            }
            int initial = 1;
            if (ctx.INT() != null) {
                initial = Integer.parseInt(ctx.INT().getText());
            }
            p.setInitialToken(initial);
        }

        @Override
        public void exitTokenImplicitPlace(PetrifyPNFormatParser.TokenImplicitPlaceContext ctx) {
            String target;
            String source = ctx.source.getText();
            Place p = this.implicitPlaces.get(new Pair<String, String>(source, target = ctx.target.getText()));
            if (p == null) {
                throw new ParseRuntimeException("There is no implicit place between '" + source + "' and '" + target + "' whose initial marking can be set");
            }
            if (p.getInitialToken().getValue() != 0L) {
                throw new ParseRuntimeException("Duplicate initial marking for place '" + p.getId() + "'");
            }
            int initial = 1;
            if (ctx.INT() != null) {
                initial = Integer.parseInt(ctx.INT().getText());
            }
            p.setInitialToken(initial);
        }

        @Override
        public void exitEventUnsplit(PetrifyPNFormatParser.EventUnsplitContext ctx) {
            this.nodeIds.put(ctx, ctx.ID().getText());
        }

        @Override
        public void exitEventSplit(PetrifyPNFormatParser.EventSplitContext ctx) {
            String id = ctx.EVENT().getText();
            int index = id.indexOf(47);
            String label = id.substring(0, index);
            int number = Integer.parseInt(id.substring(index + 1));
            if (number == 0) {
                this.nodeIds.put(ctx, label);
            } else {
                if (!this.pn.containsTransition(label)) {
                    throw new ParseRuntimeException("A non-existent event was split in '" + id + "'");
                }
                if (!this.pn.containsTransition(id)) {
                    this.pn.createTransition(id).setLabel(label);
                }
                this.nodeIds.put(ctx, id);
            }
        }
    }
}

