/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.io.parser.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.antlr.v4.runtime.tree.TerminalNode;
import uniol.apt.adt.exception.DatastructureException;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.io.parser.ParseException;
import uniol.apt.io.parser.Parser;
import uniol.apt.io.parser.impl.AbstractParser;
import uniol.apt.io.parser.impl.ParseRuntimeException;
import uniol.apt.io.parser.impl.PetrifyLTSFormatLexer;
import uniol.apt.io.parser.impl.PetrifyLTSFormatParser;
import uniol.apt.io.parser.impl.PetrifyLTSFormatParserBaseListener;
import uniol.apt.io.parser.impl.PetrifyLTSFormatParserListener;
import uniol.apt.io.parser.impl.ThrowingErrorListener;

public class PetrifyLTSParser
extends AbstractParser<TransitionSystem>
implements Parser<TransitionSystem> {
    public static final String FORMAT = "petrify";

    @Override
    public String getFormat() {
        return FORMAT;
    }

    @Override
    public List<String> getFileExtensions() {
        return Collections.unmodifiableList(Arrays.asList("g"));
    }

    @Override
    public TransitionSystem parse(InputStream is) throws ParseException, IOException {
        PetrifyLTSFormatParser.TsContext tree;
        ANTLRInputStream input = new ANTLRInputStream(is);
        PetrifyLTSFormatLexer lexer = new PetrifyLTSFormatLexer(input);
        lexer.removeErrorListeners();
        lexer.addErrorListener(new ThrowingErrorListener());
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        PetrifyLTSFormatParser parser = new PetrifyLTSFormatParser(tokens);
        parser.removeErrorListeners();
        parser.addErrorListener(new ThrowingErrorListener());
        parser.setBuildParseTree(true);
        try {
            tree = parser.ts();
        }
        catch (ParseRuntimeException ex) {
            throw ex.getParseException();
        }
        TransitionSystem lts = new TransitionSystem();
        try {
            ParseTreeWalker.DEFAULT.walk(new LTSListener(lts), tree);
        }
        catch (ParseRuntimeException ex) {
            throw ex.getParseException();
        }
        catch (DatastructureException ex) {
            throw new ParseException(ex.getMessage(), ex);
        }
        return lts;
    }

    private static class LTSListener
    extends PetrifyLTSFormatParserBaseListener
    implements PetrifyLTSFormatParserListener {
        private final TransitionSystem lts;
        private final Set<String> alphabet = new HashSet<String>();

        private LTSListener(TransitionSystem lts) {
            this.lts = lts;
        }

        @Override
        public void exitModel(PetrifyLTSFormatParser.ModelContext ctx) {
            this.lts.setName(ctx.NAME().getText());
        }

        @Override
        public void exitInputs(PetrifyLTSFormatParser.InputsContext ctx) {
            for (TerminalNode event : ctx.ID()) {
                if (this.alphabet.add(event.getText())) continue;
                throw new ParseRuntimeException("Duplicate input '" + event.getText() + "'");
            }
        }

        private void createState(String id) {
            if (!this.lts.containsState(id)) {
                this.lts.createState(id);
            }
        }

        @Override
        public void exitTransition(PetrifyLTSFormatParser.TransitionContext ctx) {
            String source = ctx.first.getText();
            this.createState(source);
            for (PetrifyLTSFormatParser.TargetContext targetCtx : ctx.target()) {
                String event = targetCtx.event.getText();
                String target = targetCtx.next.getText();
                this.createState(target);
                if (!this.alphabet.contains(event)) {
                    throw new ParseRuntimeException("Unknown event '" + event + "'");
                }
                this.lts.createArc(source, target, event);
                source = target;
            }
        }

        @Override
        public void exitMarking(PetrifyLTSFormatParser.MarkingContext ctx) {
            this.lts.setInitialState(ctx.ID().getText());
        }
    }
}

