/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.io.parser.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.antlr.v4.runtime.tree.TerminalNode;
import uniol.apt.adt.pn.Marking;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.io.parser.ParseException;
import uniol.apt.io.parser.Parser;
import uniol.apt.io.parser.impl.AbstractParser;
import uniol.apt.io.parser.impl.LoLAPNFormatBaseListener;
import uniol.apt.io.parser.impl.LoLAPNFormatLexer;
import uniol.apt.io.parser.impl.LoLAPNFormatListener;
import uniol.apt.io.parser.impl.LoLAPNFormatParser;
import uniol.apt.io.parser.impl.MarkingHashMap;
import uniol.apt.io.parser.impl.ParseRuntimeException;
import uniol.apt.io.parser.impl.ThrowingErrorListener;

public class LoLAPNParser
extends AbstractParser<PetriNet>
implements Parser<PetriNet> {
    public static final String FORMAT = "lola";

    @Override
    public String getFormat() {
        return FORMAT;
    }

    @Override
    public List<String> getFileExtensions() {
        return Collections.unmodifiableList(Arrays.asList("llnet", FORMAT));
    }

    @Override
    public PetriNet parse(InputStream is) throws ParseException, IOException {
        LoLAPNFormatParser.PnContext tree;
        ANTLRInputStream input = new ANTLRInputStream(is);
        LoLAPNFormatLexer lexer = new LoLAPNFormatLexer(input);
        lexer.removeErrorListeners();
        lexer.addErrorListener(new ThrowingErrorListener());
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        LoLAPNFormatParser parser = new LoLAPNFormatParser(tokens);
        parser.removeErrorListeners();
        parser.addErrorListener(new ThrowingErrorListener());
        parser.setBuildParseTree(true);
        try {
            tree = parser.pn();
        }
        catch (ParseRuntimeException ex) {
            throw ex.getParseException();
        }
        ParseTreeWalker walker = new ParseTreeWalker();
        LoLAPNListener listener = new LoLAPNListener();
        walker.walk(listener, tree);
        return listener.getPN();
    }

    private static class LoLAPNListener
    extends LoLAPNFormatBaseListener
    implements LoLAPNFormatListener {
        private PetriNet pn;
        private MarkingHashMap pws;
        private String curTransition;

        private LoLAPNListener() {
        }

        private PetriNet getPN() {
            return this.pn;
        }

        @Override
        public void enterPn(LoLAPNFormatParser.PnContext ctx) {
            this.pn = new PetriNet();
        }

        @Override
        public void exitPlaces(LoLAPNFormatParser.PlacesContext ctx) {
            assert (this.pn != null);
            for (TerminalNode n : ctx.ID()) {
                this.pn.createPlace(n.getText());
            }
        }

        @Override
        public void enterPwList(LoLAPNFormatParser.PwListContext ctx) {
            this.pws = new MarkingHashMap();
        }

        @Override
        public void exitPw(LoLAPNFormatParser.PwContext ctx) {
            assert (this.pws != null);
            this.pws.put(ctx.ID().getText(), Integer.parseInt(ctx.INT().getText()));
        }

        @Override
        public void exitMarking(LoLAPNFormatParser.MarkingContext ctx) {
            assert (this.pn != null);
            assert (this.pws != null);
            this.pn.setInitialMarking(new Marking(this.pn, this.pws));
            this.pws = null;
        }

        @Override
        public void enterTransition(LoLAPNFormatParser.TransitionContext ctx) {
            assert (this.pn != null);
            this.curTransition = ctx.ID().getText();
            this.pn.createTransition(this.curTransition);
        }

        @Override
        public void exitTransition(LoLAPNFormatParser.TransitionContext ctx) {
            this.curTransition = null;
        }

        @Override
        public void exitTransitionPreset(LoLAPNFormatParser.TransitionPresetContext ctx) {
            assert (this.pn != null);
            assert (this.curTransition != null);
            assert (this.pws != null);
            for (Map.Entry entry : this.pws.entrySet()) {
                this.pn.createFlow((String)entry.getKey(), this.curTransition, (int)((Integer)entry.getValue()));
            }
            this.pws = null;
        }

        @Override
        public void exitTransitionPostset(LoLAPNFormatParser.TransitionPostsetContext ctx) {
            assert (this.pn != null);
            assert (this.curTransition != null);
            assert (this.pws != null);
            for (Map.Entry entry : this.pws.entrySet()) {
                this.pn.createFlow(this.curTransition, (String)entry.getKey(), (int)((Integer)entry.getValue()));
            }
            this.pws = null;
        }
    }
}

