/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.io.parser.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import uniol.apt.io.parser.ParseException;
import uniol.apt.io.parser.Parser;

public abstract class AbstractParser<G>
implements Parser<G> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public G parseString(String input) throws ParseException {
        try (InputStream is = IOUtils.toInputStream(input);){
            Object g = this.parse(is);
            return g;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public G parseFile(String filename) throws ParseException, IOException {
        return this.parseFile(new File(filename));
    }

    @Override
    public G parseFile(File file) throws ParseException, IOException {
        try (FileInputStream is = FileUtils.openInputStream(file);){
            Object g = this.parse(is);
            return g;
        }
    }
}

