/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.io.parser;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import uniol.apt.io.parser.Parser;
import uniol.apt.io.parser.ParserNotFoundException;
import uniol.apt.io.parser.Parsers;

public class AbstractParsers<T>
implements Parsers<T> {
    private Map<String, Parser<T>> parsers = new HashMap<String, Parser<T>>();

    protected AbstractParsers(Class<T> clazz) {
        String className = clazz.getCanonicalName();
        ClassLoader cl = this.getClass().getClassLoader();
        try {
            Enumeration<URL> parserNames = cl.getResources("META-INF/uniol/apt/compiler/" + Parser.class.getCanonicalName() + "/" + className);
            while (parserNames.hasMoreElements()) {
                InputStream is = parserNames.nextElement().openStream();
                Throwable throwable = null;
                try {
                    LineIterator lIter = IOUtils.lineIterator(is, "UTF-8");
                    while (lIter.hasNext()) {
                        Parser parser;
                        Class<?> parserClass;
                        String parserName = lIter.next();
                        try {
                            parserClass = cl.loadClass(parserName);
                        }
                        catch (ClassNotFoundException ex) {
                            throw new RuntimeException(String.format("Could not load class %s", parserName), ex);
                        }
                        try {
                            parser = (Parser)parserClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        catch (ClassCastException | ReflectiveOperationException ex) {
                            throw new RuntimeException(String.format("Could not instantiate %s", parserName), ex);
                        }
                        String format = parser.getFormat();
                        if (format == null || format.equals("") || !format.equals(format.toLowerCase())) {
                            throw new RuntimeException(String.format("Parser %s reports an invalid format: %s", parserName, format));
                        }
                        Parser<T> oldParser = this.parsers.get(format);
                        if (oldParser != null && !oldParser.getClass().equals(parserClass)) {
                            throw new RuntimeException(String.format("Different parsers claim, to interpret format %s: %s and %s", format, oldParser.getClass().getCanonicalName(), parserName));
                        }
                        this.parsers.put(format, parser);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to discover parsers", ex);
        }
    }

    @Override
    public Parser<T> getParser(String format) throws ParserNotFoundException {
        Parser<T> parser = this.parsers.get(format.toLowerCase());
        if (parser == null) {
            throw new ParserNotFoundException(String.format("Parser for format %s not found.", format));
        }
        return parser;
    }

    @Override
    public Set<String> getSupportedFormats() {
        return this.parsers.keySet();
    }
}

