/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.io.converter;

import java.util.Set;
import java.util.TreeSet;
import uniol.apt.io.converter.FileBackedString;
import uniol.apt.io.parser.AbstractParsers;
import uniol.apt.io.parser.ParseException;
import uniol.apt.io.parser.Parser;
import uniol.apt.io.renderer.AbstractRenderers;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.Module;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public abstract class AbstractConvertModule<T>
extends AbstractModule
implements Module {
    private final AbstractParsers<T> parsers;
    private final AbstractRenderers<T> renderers;

    protected AbstractConvertModule(AbstractParsers<T> parsers, AbstractRenderers<T> renderers) {
        this.parsers = parsers;
        this.renderers = renderers;
    }

    @Override
    public final String getLongDescription() {
        Set<String> parseFormats = this.parsers.getSupportedFormats();
        Set<String> renderFormats = this.renderers.getSupportedFormats();
        TreeSet<String> allFormats = new TreeSet<String>();
        allFormats.addAll(parseFormats);
        allFormats.addAll(renderFormats);
        StringBuffer sb = new StringBuffer(this.getShortDescription());
        sb.append("\n\nSupported file formats:");
        for (String format : allFormats) {
            boolean canParse = parseFormats.contains(format);
            boolean canRender = renderFormats.contains(format);
            sb.append("\n - ");
            if (canParse && canRender) {
                sb.append(format);
                continue;
            }
            if (canParse && !canRender) {
                sb.append(format + " (only as input format)");
                continue;
            }
            if (!canParse && canRender) {
                sb.append(format + " (only as output format)");
                continue;
            }
            assert (false);
        }
        return sb.toString();
    }

    @Override
    public final Category[] getCategories() {
        return new Category[]{Category.CONVERTER};
    }

    @Override
    public final void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("input_format", String.class, "The format of input.", new String[0]);
        inputSpec.addParameter("output_format", String.class, "The format of output.", new String[0]);
        inputSpec.addParameter("input", FileBackedString.class, "The input string that should be converted.", new String[0]);
    }

    @Override
    public final void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("output", String.class, "file", "raw");
    }

    @Override
    public final void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        T obj;
        String inputFormat = input.getParameter("input_format", String.class);
        String outputFormat = input.getParameter("output_format", String.class);
        FileBackedString inputStr = input.getParameter("input", FileBackedString.class);
        try {
            Parser<T> parser = this.parsers.getParser(inputFormat);
            obj = parser.parseString(inputStr.toString());
        }
        catch (ParseException e) {
            throw new ModuleException("Cannot parse input: " + e.getMessage(), e);
        }
        String result = this.renderers.getRenderer(outputFormat).render(obj);
        output.setReturnValue("output", String.class, result);
    }
}

