/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.generator.tnet;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

class TransitionPresetSizeListIterator
implements Iterator<List<Integer>> {
    private final int minPlaces;
    private final int maxPlaces;
    private final int maxTransitions;
    private final boolean exactTransitionCount;
    private int curPlaces;
    private Iterator<List<Integer>> subIterator;

    TransitionPresetSizeListIterator(int maxPlaces, int maxTransitions) {
        this(1, maxPlaces, maxTransitions, false);
    }

    TransitionPresetSizeListIterator(int maxPlaces, int maxTransitions, boolean exactTransitionCount) {
        this(1, maxPlaces, maxTransitions, exactTransitionCount);
    }

    private TransitionPresetSizeListIterator(int minPlaces, int maxPlaces, int maxTransitions, boolean exactTransitionCount) {
        assert (minPlaces > 0);
        assert (maxPlaces > 0);
        assert (maxTransitions > 0);
        assert (minPlaces <= maxPlaces);
        this.minPlaces = minPlaces;
        this.maxPlaces = maxPlaces;
        this.maxTransitions = maxTransitions;
        this.exactTransitionCount = exactTransitionCount;
        this.curPlaces = minPlaces;
        this.createSubIterator();
    }

    private void createSubIterator() {
        if (2 * this.curPlaces > this.maxPlaces || this.maxTransitions <= 1) {
            this.subIterator = null;
            this.curPlaces = this.minPlaces;
        } else {
            this.subIterator = new TransitionPresetSizeListIterator(this.curPlaces, this.maxPlaces - this.curPlaces, this.maxTransitions - 1, this.exactTransitionCount);
        }
    }

    @Override
    public boolean hasNext() {
        while (this.subIterator != null && !this.subIterator.hasNext()) {
            ++this.curPlaces;
            this.createSubIterator();
        }
        if (this.subIterator == null) {
            if (this.exactTransitionCount && this.maxTransitions > 1) {
                return false;
            }
            return this.curPlaces <= this.maxPlaces;
        }
        return true;
    }

    @Override
    public List<Integer> next() {
        List<Object> list;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.subIterator == null) {
            list = new LinkedList<Integer>();
            list.add(this.curPlaces++);
        } else {
            list = this.subIterator.next();
            list.add(this.curPlaces);
        }
        return list;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

