/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.generator.tnet;

import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.adt.pn.Transition;
import uniol.apt.generator.tnet.PlacePresetListIterator;
import uniol.apt.generator.tnet.TransitionPresetSizeListIterator;

class TNetIterator
implements Iterator<PetriNet> {
    private final int maxTransitions_;
    private final Iterator<List<Integer>> transitionPresetSizeListIterator;
    private Iterator<Deque<Integer>> placePresetListIterator;
    private List<Integer> transitionPresetSizeList;
    private final boolean additionalTransitions;

    TNetIterator(int maxPlaces, int maxTransitions, boolean additionalTransitions, boolean exactTransitionCount) {
        assert (maxPlaces > 0);
        assert (maxTransitions > 0);
        this.maxTransitions_ = maxTransitions;
        this.transitionPresetSizeListIterator = new TransitionPresetSizeListIterator(maxPlaces, maxTransitions, exactTransitionCount);
        this.additionalTransitions = additionalTransitions;
        this.updatePresetSizeList();
    }

    private void updatePresetSizeList() {
        if (!this.transitionPresetSizeListIterator.hasNext()) {
            this.placePresetListIterator = null;
            return;
        }
        this.transitionPresetSizeList = this.transitionPresetSizeListIterator.next();
        int maxTransitions = this.additionalTransitions ? this.maxTransitions_ : this.transitionPresetSizeList.size();
        this.placePresetListIterator = new PlacePresetListIterator(this.transitionPresetSizeList, maxTransitions);
    }

    private static PetriNet createNet(List<Integer> transitionPresetSizeList, Deque<Integer> placePresetList) {
        Place p;
        PetriNet pn = new PetriNet();
        ArrayList<Place> places = new ArrayList<Place>();
        ArrayList<Transition> transitions = new ArrayList<Transition>();
        for (int transitionPresetSize : transitionPresetSizeList) {
            Transition t = pn.createTransition();
            for (int i = 0; i < transitionPresetSize; ++i) {
                p = pn.createPlace();
                pn.createFlow(p, t);
                places.add(p);
            }
            transitions.add(t);
        }
        assert (places.size() == placePresetList.size());
        int placeNr = 0;
        for (int preset : placePresetList) {
            Transition t;
            assert (preset <= transitions.size());
            if (preset < transitions.size()) {
                t = (Transition)transitions.get(preset);
            } else {
                t = pn.createTransition();
                transitions.add(t);
            }
            p = (Place)places.get(placeNr++);
            pn.createFlow(t, p);
        }
        return pn;
    }

    @Override
    public boolean hasNext() {
        if (this.placePresetListIterator == null) {
            return false;
        }
        if (this.placePresetListIterator.hasNext()) {
            return true;
        }
        if (this.transitionPresetSizeListIterator.hasNext()) {
            this.updatePresetSizeList();
            return true;
        }
        return false;
    }

    @Override
    public PetriNet next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return TNetIterator.createNet(this.transitionPresetSizeList, this.placePresetListIterator.next());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

