/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.generator.tnet;

import java.util.Iterator;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.generator.tnet.TNetIterator;

public class TNetGenerator
implements Iterable<PetriNet> {
    private final int maxPlaces;
    private final int maxTransitions;
    private final boolean additionalTransitions;
    private final boolean exactTransitionCount;

    public TNetGenerator(int maxPlaces) {
        this(maxPlaces, 2 * maxPlaces, true, false);
    }

    public TNetGenerator(int maxPlaces, boolean additionalTransitions) {
        this(maxPlaces, 2 * maxPlaces, additionalTransitions, false);
    }

    public TNetGenerator(int maxPlaces, boolean additionalTransitions, boolean exactTransitionCount) {
        this(maxPlaces, 2 * maxPlaces, additionalTransitions, exactTransitionCount);
    }

    public TNetGenerator(int maxPlaces, int maxTransitions) {
        this(maxPlaces, maxTransitions, true, false);
    }

    public TNetGenerator(int maxPlaces, int maxTransitions, boolean additionalTransitions, boolean exactTransitionCount) {
        if (maxTransitions <= 0) {
            throw new IllegalArgumentException("maxTransition must be positive.");
        }
        if (maxPlaces <= 0) {
            throw new IllegalArgumentException("maxPlaces must be positive.");
        }
        this.maxPlaces = maxPlaces;
        this.maxTransitions = maxTransitions;
        this.additionalTransitions = additionalTransitions;
        this.exactTransitionCount = exactTransitionCount;
    }

    @Override
    public Iterator<PetriNet> iterator() {
        return new TNetIterator(this.maxPlaces, this.maxTransitions, this.additionalTransitions, this.exactTransitionCount);
    }
}

