/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.generator.tnet;

import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

class PlacePresetListIterator
implements Iterator<Deque<Integer>> {
    private final List<Integer> transitionPresetSizeList;
    private final int index;
    private final int subIndex;
    private final int maxTransitions;
    private final int maxTransitionNr;
    private int cur;
    private Iterator<Deque<Integer>> subIterator;

    PlacePresetListIterator(List<Integer> transitionPresetSizeList, int maxTransitions) {
        this(transitionPresetSizeList, 0, 0, maxTransitions, 0, Math.min(maxTransitions - 1, transitionPresetSizeList.size()));
    }

    private PlacePresetListIterator(List<Integer> transitionPresetSizeList, int index, int subIndex, int maxTransitions, int minTransitionNr, int maxTransitionNr) {
        assert (maxTransitions > 0);
        assert (index < transitionPresetSizeList.size());
        assert (subIndex < transitionPresetSizeList.get(index));
        this.transitionPresetSizeList = transitionPresetSizeList;
        this.index = index;
        this.subIndex = subIndex;
        this.maxTransitions = maxTransitions;
        this.maxTransitionNr = maxTransitionNr;
        this.cur = minTransitionNr;
        this.createSubIterator();
    }

    private void createSubIterator() {
        int newMaxTransitionNr = Math.min(this.maxTransitions - 1, Math.max(this.maxTransitionNr, this.cur + 1));
        this.subIterator = this.subIndex < this.transitionPresetSizeList.get(this.index) - 1 ? new PlacePresetListIterator(this.transitionPresetSizeList, this.index, this.subIndex + 1, this.maxTransitions, this.cur, newMaxTransitionNr) : (this.index < this.transitionPresetSizeList.size() - 1 ? new PlacePresetListIterator(this.transitionPresetSizeList, this.index + 1, 0, this.maxTransitions, 0, newMaxTransitionNr) : null);
    }

    @Override
    public boolean hasNext() {
        if (this.subIterator != null && !this.subIterator.hasNext()) {
            ++this.cur;
            this.createSubIterator();
        }
        return this.cur <= this.maxTransitionNr;
    }

    @Override
    public Deque<Integer> next() {
        Deque<Object> list;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.subIterator == null) {
            list = new LinkedList<Integer>();
            list.addFirst(this.cur++);
        } else {
            list = this.subIterator.next();
            list.addFirst(this.cur);
        }
        return list;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

