/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.generator.philnet;

import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.adt.pn.Transition;
import uniol.apt.generator.philnet.AbstractPhilNetGenerator;
import uniol.apt.generator.philnet.Philosopher;

public class BistatePhilNetGenerator
extends AbstractPhilNetGenerator {
    @Override
    protected Philosopher addPhilPT(PetriNet pn, int i) {
        Place pfork = pn.createPlace("fork" + Integer.toString(i));
        Place peat = pn.createPlace("eating" + Integer.toString(i));
        Place pthink = pn.createPlace("thinking" + Integer.toString(i));
        pthink.setInitialToken(1L);
        pfork.setInitialToken(1L);
        Transition tput = pn.createTransition("put" + Integer.toString(i));
        Transition ttake = pn.createTransition("take" + Integer.toString(i));
        Philosopher phil = new Philosopher(pfork, new Place[]{pthink, peat}, new Transition[]{ttake, tput});
        pfork.putExtension("philosopher", phil);
        pthink.putExtension("philosopher", phil);
        peat.putExtension("philosopher", phil);
        ttake.putExtension("philosopher", phil);
        tput.putExtension("philosopher", phil);
        return phil;
    }

    @Override
    protected void addPhilA(PetriNet pn, int i, int next) {
        Place pforki = pn.getPlace("fork" + Integer.toString(i));
        Place pforkn = pn.getPlace("fork" + Integer.toString(next));
        Place peat = pn.getPlace("eating" + Integer.toString(i));
        Place pthink = pn.getPlace("thinking" + Integer.toString(i));
        Transition tput = pn.getTransition("put" + Integer.toString(i));
        Transition ttake = pn.getTransition("take" + Integer.toString(i));
        pn.createFlow(pforki, ttake);
        pn.createFlow(pforkn, ttake);
        pn.createFlow(pthink, ttake);
        pn.createFlow(ttake, peat);
        pn.createFlow(peat, tput);
        pn.createFlow(tput, pthink);
        pn.createFlow(tput, pforki);
        pn.createFlow(tput, pforkn);
    }
}

