/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.generator.module;

import uniol.apt.adt.pn.PetriNet;
import uniol.apt.generator.inverse.InverseNetGenerator;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.Module;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class InverseNetGeneratorModule
extends AbstractModule
implements Module {
    @Override
    public String getShortDescription() {
        return "Construct the inverse of a Petri net";
    }

    @Override
    public String getName() {
        return "inverse_generator";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("pn", PetriNet.class, "The argument for the inverse generator", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("pn", PetriNet.class, "file", "raw");
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        PetriNet pn = input.getParameter("pn", PetriNet.class);
        pn = InverseNetGenerator.invert(pn);
        output.setReturnValue("pn", PetriNet.class, pn);
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.GENERATOR};
    }
}

