/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.generator.module;

import java.util.HashSet;
import uniol.apt.adt.exception.ArcExistsException;
import uniol.apt.adt.ts.Arc;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.Module;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class GenerateReverseArcModule
extends AbstractModule
implements Module {
    @Override
    public String getShortDescription() {
        return "Generate reverse arcs for all arcs with a given label";
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription() + ". For all arcs labelled with the given event, an arc in the opposite direction labelled with the given reverseEvent is added.";
    }

    @Override
    public String getName() {
        return "generate_reverse_arc";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("lts", TransitionSystem.class, "The LTS that should be examined", new String[0]);
        inputSpec.addParameter("event", String.class, "The event to look for", new String[0]);
        inputSpec.addParameter("reverseEvent", String.class, "The event for the reverse arcs", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("lts", TransitionSystem.class, "file", "raw");
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        TransitionSystem ts = input.getParameter("lts", TransitionSystem.class);
        String event = input.getParameter("event", String.class);
        String reverseEvent = input.getParameter("reverseEvent", String.class);
        HashSet<Arc> arcs = new HashSet<Arc>();
        for (Arc arc : ts.getEdges()) {
            if (!arc.getLabel().equals(event)) continue;
            arcs.add(arc);
        }
        for (Arc arc : arcs) {
            try {
                ts.createArc((State)arc.getTarget(), (State)arc.getSource(), reverseEvent);
            }
            catch (ArcExistsException arcExistsException) {}
        }
        output.setReturnValue("lts", TransitionSystem.class, ts);
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.GENERATOR};
    }
}

