/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.generator.module;

import uniol.apt.adt.pn.PetriNet;
import uniol.apt.generator.cycle.CycleGenerator;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.Module;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class CycleNetGeneratorModule
extends AbstractModule
implements Module {
    @Override
    public String getShortDescription() {
        return "Construct a Petri net for a cycle of a given size with a given number of initial token.";
    }

    @Override
    public String getName() {
        return "cycle_generator";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("n", Integer.class, "The argument for the Petri net generator", new String[0]);
        inputSpec.addOptionalParameterWithDefault("init", Integer.class, 1, "1", "The number of token in the initial marking", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("pn", PetriNet.class, "file", "raw");
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        Integer n = input.getParameter("n", Integer.class);
        Integer init = input.getParameter("init", Integer.class);
        PetriNet pn = new CycleGenerator().generateNet(n, init);
        output.setReturnValue("pn", PetriNet.class, pn);
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.GENERATOR};
    }
}

