/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.generator.module;

import uniol.apt.adt.pn.PetriNet;
import uniol.apt.generator.NetGenerator;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public abstract class AbstractGeneratorModule
extends AbstractModule {
    protected abstract NetGenerator createGenerator();

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("n", Integer.class, "The argument for the Petri net generator", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("pn", PetriNet.class, "file", "raw");
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        Integer n = input.getParameter("n", Integer.class);
        PetriNet pn = this.createGenerator().generateNet(n);
        output.setReturnValue("pn", PetriNet.class, pn);
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.GENERATOR};
    }
}

