/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.generator.marking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.adt.pn.Token;
import uniol.apt.generator.GeneratorUtils;

public class MarkingNetGenerator
implements Iterable<PetriNet> {
    private final PetriNet pn;
    private final List<Place> places = new ArrayList<Place>();
    private final int tokenLimit;
    private final boolean addToInitialMarking;
    private final Collection<Set<Place>> requiredPlaces;

    public MarkingNetGenerator(PetriNet pn, int tokenLimit) {
        this(pn, tokenLimit, false);
    }

    public MarkingNetGenerator(PetriNet pn, int tokenLimit, boolean addToInitialMarking) {
        this(pn, tokenLimit, addToInitialMarking, null);
    }

    public MarkingNetGenerator(PetriNet pn, int tokenLimit, boolean addToInitialMarking, Collection<Set<Place>> requiredPlaces) {
        assert (tokenLimit >= 0);
        this.pn = pn;
        this.tokenLimit = tokenLimit;
        this.addToInitialMarking = addToInitialMarking;
        this.places.addAll(pn.getPlaces());
        this.requiredPlaces = requiredPlaces;
    }

    private PetriNet getMarkedNet(Map<String, Integer> marking) {
        PetriNet net = GeneratorUtils.cloneNet(this.pn, this.pn.getName() + " with initial marking " + marking.toString());
        for (Place p : net.getPlaces()) {
            Token mark;
            Integer token = marking.get(p.getId());
            if (token == null) {
                token = 0;
            }
            if (this.addToInitialMarking) {
                mark = this.pn.getPlace(p.getId()).getInitialToken();
                if (!mark.isOmega()) {
                    mark = Token.valueOf(mark.getValue() + (long)token.intValue());
                }
            } else {
                mark = Token.valueOf(token.intValue());
            }
            p.setInitialToken(mark);
        }
        return net;
    }

    private boolean checkRequiredPlaces(Map<String, Integer> marking) {
        if (this.requiredPlaces == null) {
            return true;
        }
        for (Set<Place> set : this.requiredPlaces) {
            boolean ok = false;
            for (Place p : set) {
                Integer token = marking.get(p.getId());
                if (token == null) continue;
                assert (token > 0);
                ok = true;
                break;
            }
            if (ok) continue;
            return false;
        }
        return true;
    }

    private boolean increaseMarking(Map<String, Integer> marking) {
        int token = 0;
        for (Map.Entry<String, Integer> entry : marking.entrySet()) {
            token += entry.getValue().intValue();
        }
        assert (token <= this.tokenLimit);
        for (int i = 0; i < this.places.size(); ++i) {
            Place place = this.places.get(i);
            Integer t = marking.get(place.getId());
            if (t == null) {
                t = 0;
            }
            if (token < this.tokenLimit) {
                Integer n = t;
                Integer n2 = t = Integer.valueOf(t + 1);
                marking.put(place.getId(), t);
                if (!this.checkRequiredPlaces(marking)) {
                    return this.increaseMarking(marking);
                }
                return true;
            }
            token -= t.intValue();
            marking.remove(place.getId());
        }
        return false;
    }

    @Override
    public Iterator<PetriNet> iterator() {
        return new Iterator<PetriNet>(){
            private Map<String, Integer> marking = new HashMap<String, Integer>();
            {
                if (MarkingNetGenerator.this.requiredPlaces != null) {
                    this.next();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return this.marking != null;
            }

            @Override
            public PetriNet next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                PetriNet result = MarkingNetGenerator.this.getMarkedNet(this.marking);
                if (!MarkingNetGenerator.this.increaseMarking(this.marking)) {
                    this.marking = null;
                }
                return result;
            }
        };
    }
}

