/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.generator.isolated;

import java.util.Iterator;
import java.util.NoSuchElementException;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.generator.GeneratorUtils;

public class IsolatedTransitionsGenerator
implements Iterable<PetriNet> {
    private final PetriNet pn;
    private final int maxTransitions;

    public IsolatedTransitionsGenerator(PetriNet pn, int maxTransitions) {
        this.pn = pn;
        this.maxTransitions = maxTransitions;
    }

    private PetriNet getNewNet(int numIsolated) {
        PetriNet net = GeneratorUtils.cloneNet(this.pn, this.pn.getName() + " with " + numIsolated + " isolated transitions");
        for (int i = 0; i < numIsolated; ++i) {
            net.createTransition();
        }
        return net;
    }

    @Override
    public Iterator<PetriNet> iterator() {
        return new Iterator<PetriNet>(){
            private int numIsolated = 0;

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return IsolatedTransitionsGenerator.this.pn.getPlaces().size() + this.numIsolated <= IsolatedTransitionsGenerator.this.maxTransitions;
            }

            @Override
            public PetriNet next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return IsolatedTransitionsGenerator.this.getNewNet(this.numIsolated++);
            }
        };
    }
}

