/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.generator.inverse;

import java.util.HashMap;
import uniol.apt.adt.pn.Flow;
import uniol.apt.adt.pn.Node;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.adt.pn.Transition;

public class InverseNetGenerator {
    private InverseNetGenerator() {
    }

    public static PetriNet invert(PetriNet orig) {
        Node n;
        PetriNet pn = new PetriNet("Inverse of " + orig.getName());
        HashMap<String, Node> nodes = new HashMap<String, Node>();
        for (Place p : orig.getPlaces()) {
            n = pn.createPlace(p);
            ((Place)n).setInitialToken(p.getInitialToken());
            nodes.put(p.getId(), n);
        }
        for (Transition t : orig.getTransitions()) {
            n = pn.createTransition(t.getId());
            ((Transition)n).setLabel(t.getLabel());
            nodes.put(t.getId(), n);
        }
        for (Flow arc : orig.getEdges()) {
            Node source = (Node)nodes.get(((Node)arc.getSource()).getId());
            Node target = (Node)nodes.get(((Node)arc.getTarget()).getId());
            assert (source != null && target != null);
            Flow n2 = pn.createFlow(target, source);
            n2.setWeight(arc.getWeight());
        }
        return pn;
    }
}

