/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.generator.cycle;

import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.adt.pn.Transition;

public class CycleGenerator {
    public PetriNet generateNet(int n) {
        return this.generateNet(n, 1);
    }

    public PetriNet generateNet(int n, int init) {
        Place p;
        if (n < 1) {
            throw new IllegalArgumentException("Cannot construct cycles of a non-positive size");
        }
        PetriNet pn = new PetriNet("Cycle of size " + String.valueOf(n) + " with " + String.valueOf(init) + " tokens");
        Place pfirst = p = pn.createPlace("p0");
        Transition t = pn.createTransition("t0");
        p.setInitialToken(init);
        pn.createFlow(p, t);
        for (int i = 1; i < n; ++i) {
            p = pn.createPlace("p" + Integer.toString(i));
            pn.createFlow(t, p);
            t = pn.createTransition("t" + Integer.toString(i));
            pn.createFlow(p, t);
        }
        pn.createFlow(t, pfirst);
        return pn;
    }
}

