/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.generator.bitnet;

import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.adt.pn.Transition;
import uniol.apt.generator.bitnet.BitNetGenerator;

public class ConnectedBitNetGenerator
implements BitNetGenerator {
    private static final String BIT_NAME_PATTERN = "bit%d_state%d";

    @Override
    public PetriNet generateNet(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Number of bits must at least be 1.");
        }
        PetriNet pn = new PetriNet("Connected " + String.valueOf(n) + "-bit net");
        Place unset = pn.createPlace(String.format(BIT_NAME_PATTERN, 0, 0));
        Place set = pn.createPlace(String.format(BIT_NAME_PATTERN, 0, 1));
        unset.setInitialToken(1L);
        Transition t = pn.createTransition("set0");
        pn.createFlow(unset, t);
        pn.createFlow(t, set);
        for (int i = 1; i < n; ++i) {
            t = pn.createTransition("unset" + Integer.toString(i - 1) + "_set" + Integer.toString(i));
            pn.createFlow(set, t);
            pn.createFlow(t, unset);
            unset = pn.createPlace(String.format(BIT_NAME_PATTERN, i, 0));
            set = pn.createPlace(String.format(BIT_NAME_PATTERN, i, 1));
            unset.setInitialToken(1L);
            pn.createFlow(unset, t);
            pn.createFlow(t, set);
        }
        t = pn.createTransition("unset" + Integer.toString(n - 1));
        pn.createFlow(set, t);
        pn.createFlow(t, unset);
        return pn;
    }
}

