/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.generator;

import java.util.HashMap;
import uniol.apt.adt.pn.Flow;
import uniol.apt.adt.pn.Node;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.adt.pn.Transition;

public class GeneratorUtils {
    private GeneratorUtils() {
    }

    public static PetriNet cloneNet(PetriNet pn, String id) {
        PetriNet net = new PetriNet(id);
        HashMap<Node, Node> nodes = new HashMap<Node, Node>();
        for (Place place : pn.getPlaces()) {
            Place p = net.createPlace(place);
            p.setInitialToken(place.getInitialToken());
            nodes.put(place, p);
        }
        for (Transition trans : pn.getTransitions()) {
            Transition t = net.createTransition(trans);
            t.setLabel(trans.getLabel());
            nodes.put(trans, t);
        }
        for (Flow arc : pn.getEdges()) {
            Node source = (Node)nodes.get(arc.getSource());
            Node target = (Node)nodes.get(arc.getTarget());
            assert (source != null && target != null);
            Flow otherArc = net.createFlow(source, target);
            otherArc.setWeight(arc.getWeight());
        }
        return net;
    }
}

