/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.extension;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import uniol.apt.adt.ts.Arc;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.lts.extension.ExtendTransitionSystem;
import uniol.apt.extension.ExtendMode;
import uniol.apt.extension.ExtendStateFile;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.Module;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class ExtendTSModule
extends AbstractModule
implements Module {
    @Override
    public String getName() {
        return "extend_lts";
    }

    @Override
    public String getShortDescription() {
        return "Generate extensions to a given LTS that satisfy certain properties.";
    }

    @Override
    public String getLongDescription() {
        return "Generate extensions to a given LTS that are reversible, persistent. Also, all smallest cycles share the same parikh vector. This module can run in three different modes: It can generate the next possible extension to the given LTS, the next extension that satisfies the above properties or the next satisfying extension that is also minimal among satisfying extensions.";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("lts", TransitionSystem.class, "The LTS that is extended", new String[0]);
        inputSpec.addParameter("g", Integer.class, "Maximum number of new nodes", new String[0]);
        inputSpec.addParameter("mode", ExtendMode.class, "The mode (next, next_valid, next_minimal_valid)", new String[0]);
        inputSpec.addParameter("state_file", String.class, "The file to load/save the state from/to", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("valid", Boolean.class, new String[0]);
        outputSpec.addReturnValue("minimal", Boolean.class, new String[0]);
        outputSpec.addReturnValue("extended_lts", TransitionSystem.class, "file", "raw");
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        ExtendTransitionSystem extender;
        TransitionSystem ts = input.getParameter("lts", TransitionSystem.class);
        int g = input.getParameter("g", Integer.class);
        ExtendMode mode = input.getParameter("mode", ExtendMode.class);
        String stateFileName = input.getParameter("state_file", String.class);
        File stateFile = new File(stateFileName);
        ArrayList<String> labels = new ArrayList<String>();
        for (Arc e : ts.getEdges()) {
            if (labels.contains(e.getLabel())) continue;
            labels.add(e.getLabel());
        }
        int codeLength = ts.getNodes().size() + g;
        codeLength *= codeLength * labels.size();
        ExtendStateFile state = new ExtendStateFile(stateFile, codeLength);
        BitSet currentCode = null;
        if (stateFile.exists()) {
            try {
                state.parse();
            }
            catch (IOException e) {
                throw new ModuleException("Can't parse state file");
            }
            extender = new ExtendTransitionSystem(ts, g, state.getMinimalCodes());
            currentCode = state.getCurrentCode();
        } else {
            extender = new ExtendTransitionSystem(ts, g);
        }
        if (currentCode != null) {
            switch (mode) {
                case Next: {
                    extender.findNext();
                    break;
                }
                case NextValid: {
                    extender.findNextValid(currentCode);
                    break;
                }
                case NextMinimalValid: {
                    extender.findNextMinimal(currentCode);
                }
            }
        } else {
            switch (mode) {
                case Next: {
                    extender.findNext();
                    break;
                }
                case NextValid: {
                    extender.findNextValid();
                    break;
                }
                case NextMinimalValid: {
                    extender.findNextMinimal();
                }
            }
        }
        BitSet newCode = extender.getLastGenerated();
        boolean valid = extender.isLastGeneratedValid();
        boolean minimal = false;
        if (valid) {
            minimal = extender.isLastGeneratedMinimal();
        }
        state.setMinimalCodes(extender.getListOfMinimals());
        state.setCurrentCode(newCode);
        TransitionSystem extendedTS = extender.buildLTS(newCode);
        try {
            state.render();
        }
        catch (IOException e) {
            throw new ModuleException("Can't render state file");
        }
        output.setReturnValue("extended_lts", TransitionSystem.class, extendedTS);
        output.setReturnValue("valid", Boolean.class, valid);
        if (valid) {
            output.setReturnValue("minimal", Boolean.class, minimal);
        } else {
            output.setReturnValue("minimal", Boolean.class, null);
        }
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.LTS};
    }
}

