/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.extension;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import uniol.apt.module.exception.ModuleException;

public class ExtendStateFile {
    private static final String MINIMAL_CODE_PREFIX = "m:";
    private static final String CURRENT_CODE_PREFIX = "c:";
    private final File file;
    private final int codeLength;
    private BitSet currentCode;
    private List<BitSet> minimalCodes;

    public ExtendStateFile(File file, int codeLength) {
        this.file = file;
        this.codeLength = codeLength;
        this.setMinimalCodes(new ArrayList<BitSet>());
        this.currentCode = null;
    }

    private BitSet codeStringToCode(String codeString) {
        BitSet code = new BitSet(this.codeLength);
        for (int i = 0; i < codeString.length(); ++i) {
            if (codeString.charAt(i) != '1') continue;
            code.set(i);
        }
        return code;
    }

    private String codeToCodeString(BitSet code) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.codeLength; ++i) {
            if (code.get(i)) {
                builder.append('1');
                continue;
            }
            builder.append('0');
        }
        return builder.toString();
    }

    public void parse() throws IOException, ModuleException {
        try (FileInputStream is = FileUtils.openInputStream(this.file);
             InputStreamReader isr = new InputStreamReader((InputStream)is, "UTF-8");
             BufferedReader reader = new BufferedReader(isr);){
            String line;
            while ((line = reader.readLine()) != null) {
                String codeString;
                if (line.length() - MINIMAL_CODE_PREFIX.length() != this.codeLength) {
                    throw new ModuleException("State file was created for different LTS or g. Delete file and try again.");
                }
                if (line.startsWith(MINIMAL_CODE_PREFIX)) {
                    codeString = line.substring(MINIMAL_CODE_PREFIX.length());
                    this.minimalCodes.add(this.codeStringToCode(codeString));
                    continue;
                }
                if (line.startsWith(CURRENT_CODE_PREFIX)) {
                    codeString = line.substring(CURRENT_CODE_PREFIX.length());
                    this.currentCode = this.codeStringToCode(codeString);
                    continue;
                }
                throw new ModuleException(this.file.getAbsolutePath() + "is not a state file");
            }
        }
    }

    public void render() throws IOException {
        try (FileOutputStream os = FileUtils.openOutputStream(this.file);
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, "UTF-8");
             BufferedWriter writer = new BufferedWriter(osw);){
            for (BitSet code : this.minimalCodes) {
                writer.write(MINIMAL_CODE_PREFIX + this.codeToCodeString(code) + "\n");
            }
            writer.write(CURRENT_CODE_PREFIX + this.codeToCodeString(this.currentCode) + "\n");
        }
    }

    public BitSet getCurrentCode() {
        return this.currentCode;
    }

    public List<BitSet> getMinimalCodes() {
        return this.minimalCodes;
    }

    public void setCurrentCode(BitSet currentCode) {
        this.currentCode = currentCode;
    }

    public void setMinimalCodes(List<BitSet> minimalCodes) {
        this.minimalCodes = minimalCodes;
    }
}

