/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;

public abstract class AbstractServiceProcessor
extends AbstractProcessor {
    protected final Class<? extends Annotation> annotationClass;
    protected final String interfaceName;
    protected final boolean allowGenerics;
    protected Elements elements;
    protected Types types;
    private Filer filer;
    private Messager messager;
    private boolean finished;

    protected AbstractServiceProcessor(Class<? extends Annotation> annotationClass, Class<?> interfaceClass, boolean allowGenerics) {
        this(annotationClass, interfaceClass.getCanonicalName(), allowGenerics);
    }

    protected AbstractServiceProcessor(Class<? extends Annotation> annotationClass, String interfaceName, boolean allowGenerics) {
        this.annotationClass = annotationClass;
        this.interfaceName = interfaceName;
        this.allowGenerics = allowGenerics;
    }

    protected abstract void visitClass(TypeElement var1, String var2);

    protected abstract void produceOutput();

    @Override
    public synchronized void init(ProcessingEnvironment procEnv) {
        super.init(procEnv);
        this.elements = procEnv.getElementUtils();
        this.types = procEnv.getTypeUtils();
        this.filer = this.processingEnv.getFiler();
        this.messager = this.processingEnv.getMessager();
        this.finished = false;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> annotations = new HashSet<String>();
        annotations.add(this.annotationClass.getCanonicalName());
        return annotations;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.finished) {
            return false;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(this.annotationClass)) {
            if (!this.isValidClass(element)) {
                return false;
            }
            TypeElement classEle = (TypeElement)element;
            String className = classEle.getQualifiedName().toString();
            this.visitClass(classEle, className);
        }
        this.produceOutput();
        this.finished = true;
        return true;
    }

    protected void writeResourceList(String resourceName, Collection<String> entries) throws IOException {
        FileObject fo2;
        entries = new TreeSet<String>(entries);
        try {
            fo2 = this.filer.getResource(StandardLocation.CLASS_OUTPUT, "", resourceName);
            InputStream is = fo2.openInputStream();
            Object object = null;
            try {
                LineIterator lIter = IOUtils.lineIterator(is, "UTF-8");
                while (lIter.hasNext()) {
                    String entry = lIter.next();
                    entries.add(entry);
                }
            }
            catch (Throwable lIter) {
                object = lIter;
                throw lIter;
            }
            finally {
                if (is != null) {
                    if (object != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable lIter) {
                            ((Throwable)object).addSuppressed(lIter);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (IOException fo2) {
            // empty catch block
        }
        fo2 = this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", resourceName, new Element[0]);
        Writer writer = fo2.openWriter();
        for (String entry : entries) {
            writer.append(entry + "\n");
        }
        writer.close();
    }

    private boolean isValidClass(Element ele) {
        TypeElement classEle;
        if (ele.getKind() != ElementKind.CLASS) {
            this.error(ele, "Non-Class %s annotated with %s.", ele.getSimpleName().toString(), this.annotationClass.getCanonicalName());
        }
        if (!(classEle = (TypeElement)ele).getModifiers().contains((Object)Modifier.PUBLIC)) {
            this.error(classEle, "Class %s is not public.", classEle.getQualifiedName().toString());
            return false;
        }
        if (classEle.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            this.error(classEle, "Class %s is abstract.", classEle.getQualifiedName().toString());
            return false;
        }
        TypeMirror expected = this.types.erasure(this.elements.getTypeElement(this.interfaceName).asType());
        boolean found = false;
        for (TypeMirror typeMirror : classEle.getInterfaces()) {
            if (!this.types.isAssignable(typeMirror, expected)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.error(classEle, "Class %s doesn't implement interface %s.", classEle.getQualifiedName().toString(), this.interfaceName);
            return false;
        }
        if (!this.allowGenerics && !classEle.getTypeParameters().isEmpty()) {
            this.error(classEle, "Class %s is generic.", classEle.getQualifiedName().toString());
            return false;
        }
        for (Element element : classEle.getEnclosedElements()) {
            ExecutableElement constructorEle;
            if (element.getKind() != ElementKind.CONSTRUCTOR || (constructorEle = (ExecutableElement)element).getParameters().size() != 0 || !constructorEle.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            return true;
        }
        this.error(classEle, String.format("Class %s needs an public no-arg constructor", classEle.getQualifiedName().toString()), new Object[0]);
        return false;
    }

    protected void error(String fmt, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(fmt, args));
        this.finished = true;
    }

    protected void error(Element ele, String fmt, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(fmt, args), ele);
        this.finished = true;
    }
}

