/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.compiler;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import uniol.apt.compiler.AbstractServiceProcessor;
import uniol.apt.compiler.MyTypes;

public abstract class AbstractAptServiceProcessor
extends AbstractServiceProcessor {
    private Map<String, Set<String>> services;

    protected AbstractAptServiceProcessor(Class<? extends Annotation> annotationClass, Class<?> interfaceClass) {
        super(annotationClass, interfaceClass, false);
    }

    protected AbstractAptServiceProcessor(Class<? extends Annotation> annotationClass, String interfaceName) {
        super(annotationClass, interfaceName, false);
    }

    private Set<String> getSet(String type) {
        Set<String> ret = this.services.get(type);
        if (ret == null) {
            ret = new HashSet<String>();
            this.services.put(type, ret);
        }
        return ret;
    }

    @Override
    public synchronized void init(ProcessingEnvironment procEnv) {
        super.init(procEnv);
        this.services = new HashMap<String, Set<String>>();
    }

    @Override
    protected void visitClass(TypeElement classEle, String className) {
        TypeMirror searched = this.types.erasure(this.elements.getTypeElement(this.interfaceName).asType());
        for (TypeMirror typeMirror : classEle.getInterfaces()) {
            if (!this.types.isSameType(this.types.erasure(typeMirror), searched)) continue;
            String type = MyTypes.asDeclaredType(typeMirror).getTypeArguments().get(0).toString();
            this.getSet(type).add(className);
        }
    }

    @Override
    protected void produceOutput() {
        try {
            String resourcePrefix = "META-INF/uniol/apt/compiler/" + this.interfaceName + "/";
            for (Map.Entry<String, Set<String>> entry : this.services.entrySet()) {
                this.writeResourceList(resourcePrefix + entry.getKey(), (Collection<String>)entry.getValue());
            }
        }
        catch (IOException ex) {
            this.error("Caught IOException: %s", ex.getMessage());
        }
    }
}

