/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.check;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import uniol.apt.adt.pn.Flow;
import uniol.apt.adt.pn.Node;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.adt.pn.Transition;

public class SmartChanceGenerator {
    private static final int NUMBER_BASE_MODIFICATIONS = 5;
    private static final int MAX_UNDOS_ALLOWED = 16;
    private PetriNet net;
    private Random rnd;
    private int lastScore;
    private int bestScore;
    private int bestScoreHistoryIndex;
    private int numUndosDone;
    private int maxDistanceToBestScore;
    private Stack<ModificationStep> history;
    private HashMap<ModificationType, Double> chances;
    private HashMap<ModificationType, Double> penalties;
    private HashMap<ModificationType, Double> uses;

    public SmartChanceGenerator(long seed) {
        this.rnd = seed != 0L ? new Random(seed) : new Random();
    }

    public void renewNet(int initMarkingValue) {
        this.reset();
        Place p = this.net.createPlace("p0");
        Transition t = this.net.createTransition("t0");
        if (initMarkingValue > 0) {
            p.setInitialToken(initMarkingValue);
        }
        if (this.rnd.nextDouble() >= 0.5) {
            this.net.createFlow(p, t);
        } else {
            this.net.createFlow(t, p);
        }
        for (int i = 0; i < Math.abs(5); ++i) {
            this.addBaseModification();
        }
    }

    private void addBaseModification() {
        double r = this.rnd.nextDouble();
        if (this.net.getTransitions().size() + this.net.getPlaces().size() < 6) {
            r *= 0.8;
        }
        if (r < 0.4) {
            this.addPlace();
        } else if (r < 0.8) {
            this.addTransition();
        } else {
            this.addArc();
        }
    }

    protected void reset() {
        this.net = new PetriNet();
        this.history = new Stack();
        this.lastScore = 0;
        this.bestScore = 0;
        this.bestScoreHistoryIndex = -1;
        this.numUndosDone = 0;
        this.maxDistanceToBestScore = 8;
        this.resetChances();
    }

    protected void resetChances() {
        if (this.chances == null) {
            this.chances = new HashMap();
            this.penalties = new HashMap();
            this.uses = new HashMap();
        } else {
            this.chances.clear();
        }
        this.chances.put(ModificationType.Place, 1.0);
        this.chances.put(ModificationType.Transition, 1.0);
        this.chances.put(ModificationType.Mark, 1.0);
        this.chances.put(ModificationType.Arc, 1.0);
        this.chances.put(ModificationType.Weight, 1.0);
        this.penalties.put(ModificationType.Place, 0.0);
        this.penalties.put(ModificationType.Transition, 0.0);
        this.penalties.put(ModificationType.Mark, 0.0);
        this.penalties.put(ModificationType.Arc, 0.0);
        this.penalties.put(ModificationType.Weight, 0.0);
        this.uses.put(ModificationType.Place, 0.0);
        this.uses.put(ModificationType.Transition, 0.0);
        this.uses.put(ModificationType.Mark, 0.0);
        this.uses.put(ModificationType.Arc, 0.0);
        this.uses.put(ModificationType.Weight, 0.0);
    }

    public PetriNet generateNet(int value, int initMarkingValue) {
        boolean success = false;
        boolean validation = false;
        if (this.net == null) {
            this.renewNet(initMarkingValue);
            return this.net;
        }
        validation = this.validateScore(value);
        if (validation) {
            for (int i = 0; i < 8 && !success; ++i) {
                success = this.getRandomModification();
            }
        }
        if (!success || !validation) {
            this.renewNet(initMarkingValue);
        }
        return this.net;
    }

    protected boolean validateScore(int value) {
        if (value <= 0) {
            return this.history.size() < 16;
        }
        if (this.history.size() == 0) {
            return true;
        }
        ModificationType mod = this.history.peek().getType();
        if (value > this.lastScore) {
            this.validateHigherScore(mod, value);
        } else if (value <= this.lastScore) {
            if (this.history.size() - this.bestScoreHistoryIndex > this.maxDistanceToBestScore && this.history.size() > 8) {
                if (this.numUndosDone >= Math.abs(16)) {
                    return false;
                }
                while (this.history.size() > this.bestScoreHistoryIndex) {
                    if (this.undoModification()) continue;
                    return false;
                }
                ++this.numUndosDone;
            }
            if (value == this.lastScore) {
                this.validateNoScoreChange(mod);
            }
            if (value < this.lastScore) {
                this.validateLesserScore(mod);
            }
        }
        this.updateMaxDistanceToBestScore();
        this.lastScore = value;
        return true;
    }

    private void validateHigherScore(ModificationType mod, int value) {
        if (value > this.bestScore) {
            this.bestScore = value;
            this.bestScoreHistoryIndex = this.history.size() - 1;
            this.chances.put(mod, this.chances.get((Object)mod) + (double)(this.bestScore - this.lastScore));
        }
    }

    private void validateNoScoreChange(ModificationType mod) {
        for (ModificationType type : this.chances.keySet()) {
            if (type == mod) {
                this.chances.put(type, this.chances.get((Object)mod) - 0.1);
                continue;
            }
            this.chances.put(type, this.chances.get((Object)mod) + 0.05);
        }
    }

    private void validateLesserScore(ModificationType mod) {
        this.penalties.put(mod, this.penalties.get((Object)mod) + 1.0);
        if (this.uses.get((Object)mod) > 4.0) {
            if (this.penalties.get((Object)mod) / this.uses.get((Object)mod) > 0.75) {
                this.chances.put(mod, -0.5);
            } else {
                this.chances.put(mod, this.chances.get((Object)mod) - 0.2);
            }
        }
    }

    private void updateMaxDistanceToBestScore() {
        this.maxDistanceToBestScore = this.history.size() < 32 ? this.history.size() / 2 : (this.history.size() <= 64 ? this.history.size() : (this.history.size() <= 128 ? 16 + (128 - this.history.size()) / 8 : 8));
    }

    private boolean getRandomModification() {
        double d = 0.0;
        double max = 0.0;
        double p = 0.0;
        double sum = 0.0;
        int i = 0;
        for (Double d2 : this.chances.values()) {
            d = d2;
            if (!(d > 0.0)) continue;
            ++i;
            max += d;
        }
        if (d <= 0.2 || i < 2) {
            this.resetChances();
        }
        p = this.rnd.nextDouble() * max;
        for (Map.Entry entry : this.chances.entrySet()) {
            if (!(p <= (sum += ((Double)entry.getValue()).doubleValue()))) continue;
            return this.doModification((ModificationType)((Object)entry.getKey()));
        }
        return false;
    }

    protected boolean doModification(ModificationType mod) {
        Object obj = null;
        switch (mod) {
            case Place: {
                obj = this.addPlace();
                break;
            }
            case Transition: {
                obj = this.addTransition();
                break;
            }
            case Mark: {
                obj = this.addMark();
                break;
            }
            case Arc: {
                obj = this.addArc();
                break;
            }
            case Weight: {
                obj = this.addWeight();
                break;
            }
        }
        if (obj == null) {
            return false;
        }
        this.history.push(new ModificationStep(obj, mod));
        this.uses.put(mod, this.uses.get((Object)mod) + 1.0);
        return true;
    }

    protected boolean undoModification() {
        if (this.net == null) {
            return false;
        }
        if (this.history.size() <= 0) {
            return false;
        }
        ModificationType mod = this.history.peek().getType();
        Object obj = this.history.peek().getObject();
        try {
            switch (mod) {
                case Place: {
                    this.net.removePlace((Place)obj);
                    break;
                }
                case Transition: {
                    this.net.removeTransition((Transition)obj);
                    break;
                }
                case Mark: {
                    ((Place)obj).setInitialToken(((Place)obj).getInitialToken().getValue() - 1L);
                    break;
                }
                case Arc: {
                    this.net.removeFlow((Node)((Flow)obj).getSource(), (Node)((Flow)obj).getTarget());
                    break;
                }
                case Weight: {
                    ((Flow)obj).setWeight(((Flow)obj).getWeight() - 1);
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        this.history.pop();
        return true;
    }

    private Object addPlace() {
        int sizeT = this.net.getTransitions().size();
        int sizeP = this.net.getPlaces().size();
        Place p = null;
        Transition t = null;
        try {
            p = this.net.createPlace("p" + sizeP);
            t = this.net.getTransition("t" + this.rnd.nextInt(sizeT));
            if (this.rnd.nextDouble() >= 0.5) {
                this.net.createFlow(t, p);
            } else {
                this.net.createFlow(p, t);
            }
        }
        catch (Exception e) {
            if (p != null) {
                this.net.removePlace(p);
            }
            return null;
        }
        return p;
    }

    private Object addTransition() {
        int sizeT = this.net.getTransitions().size();
        int sizeP = this.net.getPlaces().size();
        Place p = null;
        Transition t = null;
        try {
            t = this.net.createTransition("t" + sizeT);
            p = this.net.getPlace("p" + this.rnd.nextInt(sizeP));
            if (this.rnd.nextDouble() >= 0.5) {
                this.net.createFlow(t, p);
            } else {
                this.net.createFlow(p, t);
            }
        }
        catch (Exception e) {
            if (t != null) {
                this.net.removeTransition(t);
            }
            return null;
        }
        return t;
    }

    private Object addMark() {
        try {
            Place p = this.net.getPlace("p" + this.rnd.nextInt(this.net.getPlaces().size()));
            p.setInitialToken(p.getInitialToken().getValue() + 1L);
            return p;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Object addWeight() {
        try {
            Set<Flow> edges = this.net.getEdges();
            int i = this.rnd.nextInt(edges.size());
            for (Flow f : edges) {
                if (i == 0) {
                    f.setWeight(f.getWeight() + 1);
                    return f;
                }
                --i;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private Object addArc() {
        Transition t = this.net.getTransition("t" + this.rnd.nextInt(this.net.getTransitions().size()));
        Place p = this.net.getPlace("p" + this.rnd.nextInt(this.net.getPlaces().size()));
        Flow f = null;
        try {
            f = this.rnd.nextDouble() >= 0.5 ? this.net.createFlow(p, t) : this.net.createFlow(t, p);
            return f;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static class ModificationStep {
        private Object obj;
        private ModificationType modification;

        private ModificationStep(Object obj, ModificationType mod) {
            this.obj = obj;
            this.modification = mod;
        }

        public Object getObject() {
            return this.obj;
        }

        public ModificationType getType() {
            return this.modification;
        }
    }

    public static enum ModificationType {
        Place,
        Transition,
        Mark,
        Arc,
        Weight;

    }
}

