/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.check;

import java.util.ArrayList;
import java.util.Iterator;

public class CheckParameters
extends ArrayList<Integer> {
    private static final long serialVersionUID = 43L;
    private int minValue = 0;
    private ParameterModifyType modifyMode = ParameterModifyType.BruteForce;
    private boolean active = true;

    public void setNumberOfParameters(int number) {
        for (int i = 0; i < number; ++i) {
            this.add(this.minValue);
        }
    }

    public void modify(int score, int markingFactor) {
        if (this.active) {
            int greatestNumber = this.getGreatestNumber();
            if (this.modifyMode == ParameterModifyType.BruteForce) {
                if (this.areAllNumbersEqual()) {
                    this.set(0, greatestNumber + 1);
                    for (int index = 1; index < this.size(); ++index) {
                        this.set(index, this.minValue);
                    }
                } else {
                    this.increment(greatestNumber);
                    while (!this.contains(greatestNumber)) {
                        this.increment(greatestNumber);
                    }
                }
            } else if (this.modifyMode == ParameterModifyType.Score) {
                this.set(0, score);
                this.set(1, markingFactor);
            }
        }
    }

    private void increment(int greatestNumber) {
        this.set(0, (Integer)this.get(0) + 1);
        for (int index = 1; index < this.size(); ++index) {
            if ((Integer)this.get(index - 1) <= greatestNumber) continue;
            this.set(index - 1, this.minValue);
            this.set(index, (Integer)this.get(index) + 1);
        }
    }

    private int getGreatestNumber() {
        int greatestNumber = this.minValue;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            int number = (Integer)iterator.next();
            if (number <= greatestNumber) continue;
            greatestNumber = number;
        }
        return greatestNumber;
    }

    private boolean areAllNumbersEqual() {
        int refNumber = (Integer)this.get(0);
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            int number = (Integer)iterator.next();
            if (number == refNumber) continue;
            return false;
        }
        return true;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
    }

    public ParameterModifyType getModifyMode() {
        return this.modifyMode;
    }

    public void setModifyMode(ParameterModifyType modifyMode) {
        this.modifyMode = modifyMode;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public static enum ParameterModifyType {
        BruteForce,
        Score;

    }
}

