/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.check;

import java.util.Iterator;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.check.ChanceGenerator;
import uniol.apt.check.CheckParameters;
import uniol.apt.check.SmartChanceGenerator;
import uniol.apt.check.UnsupportedGeneratorException;
import uniol.apt.generator.bitnet.SimpleBitNetGenerator;
import uniol.apt.generator.cycle.CycleGenerator;
import uniol.apt.generator.marking.MarkingIterable;
import uniol.apt.generator.philnet.QuadstatePhilNetGenerator;
import uniol.apt.generator.philnet.TristatePhilNetGenerator;
import uniol.apt.generator.tnet.TNetGenerator;

public class CheckGenerator {
    private String generator_;
    private CheckParameters parameters_;
    private ChanceGenerator chanceGenerator = new ChanceGenerator();
    private SmartChanceGenerator smartChanceGenerator = new SmartChanceGenerator(0L);
    private MarkingIterable markingNetGenerator = null;
    private Iterator<PetriNet> petriNetIterator = null;

    CheckGenerator() {
    }

    public void setGenerator(String name) {
        this.generator_ = name;
    }

    public PetriNet getPNs() {
        PetriNet returnNet = null;
        if (this.generator_.equals("cycle")) {
            CycleGenerator generator = new CycleGenerator();
            returnNet = generator.generateNet((Integer)this.parameters_.get(0));
        } else if (this.generator_.equals("bitnet")) {
            SimpleBitNetGenerator generator = new SimpleBitNetGenerator();
            returnNet = generator.generateNet((Integer)this.parameters_.get(0));
        } else if (this.generator_.equals("triPhilgen")) {
            TristatePhilNetGenerator generator = new TristatePhilNetGenerator();
            returnNet = generator.generateNet((Integer)this.parameters_.get(0));
        } else if (this.generator_.equals("quadPhilgen")) {
            QuadstatePhilNetGenerator generator = new QuadstatePhilNetGenerator();
            returnNet = generator.generateNet((Integer)this.parameters_.get(0));
        } else if (this.generator_.equals("chance")) {
            returnNet = this.chanceGenerator.generateNet((Integer)this.parameters_.get(0), (Integer)this.parameters_.get(1));
        } else if (this.generator_.equals("smartchance")) {
            returnNet = this.smartChanceGenerator.generateNet((Integer)this.parameters_.get(0), (Integer)this.parameters_.get(1));
        } else if (this.generator_.equals("tnetgen2")) {
            if (this.petriNetIterator == null) {
                this.markingNetGenerator = new MarkingIterable(new TNetGenerator((Integer)this.parameters_.get(0)), (Integer)this.parameters_.get(1));
                this.petriNetIterator = this.markingNetGenerator.iterator();
            }
            if (this.petriNetIterator.hasNext()) {
                returnNet = this.petriNetIterator.next();
                this.parameters_.setActive(false);
            } else {
                this.petriNetIterator = null;
                this.parameters_.setActive(true);
            }
        } else if (this.generator_.equals("tnetgen3")) {
            if (this.petriNetIterator == null) {
                this.markingNetGenerator = new MarkingIterable(new TNetGenerator((int)((Integer)this.parameters_.get(0)), (Integer)this.parameters_.get(1)), (Integer)this.parameters_.get(2));
                this.petriNetIterator = this.markingNetGenerator.iterator();
            }
            if (this.petriNetIterator.hasNext()) {
                returnNet = this.petriNetIterator.next();
                this.parameters_.setActive(false);
            } else {
                this.petriNetIterator = null;
                this.parameters_.setActive(true);
            }
        }
        return returnNet;
    }

    public CheckParameters getParameters() {
        return this.parameters_;
    }

    public void setInitialParameters(CheckParameters parameters) throws UnsupportedGeneratorException {
        this.parameters_ = parameters;
        if (this.generator_.equals("cycle")) {
            this.parameters_.setMinValue(1);
            this.parameters_.setNumberOfParameters(1);
            this.parameters_.setModifyMode(CheckParameters.ParameterModifyType.BruteForce);
        } else if (this.generator_.equals("bitnet")) {
            this.parameters_.setMinValue(1);
            this.parameters_.setNumberOfParameters(1);
            this.parameters_.setModifyMode(CheckParameters.ParameterModifyType.BruteForce);
        } else if (this.generator_.equals("triPhilgen")) {
            this.parameters_.setMinValue(2);
            this.parameters_.setNumberOfParameters(1);
            this.parameters_.setModifyMode(CheckParameters.ParameterModifyType.BruteForce);
        } else if (this.generator_.equals("quadPhilgen")) {
            this.parameters_.setMinValue(2);
            this.parameters_.setNumberOfParameters(1);
            this.parameters_.setModifyMode(CheckParameters.ParameterModifyType.BruteForce);
        } else if (this.generator_.equals("chance")) {
            this.parameters_.setMinValue(-1);
            this.parameters_.setNumberOfParameters(2);
            this.parameters_.setModifyMode(CheckParameters.ParameterModifyType.Score);
        } else if (this.generator_.equals("smartchance")) {
            this.parameters_.setMinValue(-1);
            this.parameters_.setNumberOfParameters(2);
            this.parameters_.setModifyMode(CheckParameters.ParameterModifyType.Score);
        } else if (this.generator_.equals("tnetgen2")) {
            this.parameters_.setMinValue(1);
            this.parameters_.setNumberOfParameters(2);
            this.parameters_.setModifyMode(CheckParameters.ParameterModifyType.BruteForce);
        } else if (this.generator_.equals("tnetgen3")) {
            this.parameters_.setMinValue(1);
            this.parameters_.setNumberOfParameters(3);
            this.parameters_.setModifyMode(CheckParameters.ParameterModifyType.BruteForce);
        } else {
            throw new UnsupportedGeneratorException(this.generator_);
        }
    }
}

