/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.check;

import java.util.HashSet;
import java.util.Set;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Transition;
import uniol.apt.analysis.bounded.Bounded;
import uniol.apt.analysis.exception.PreconditionFailedException;
import uniol.apt.analysis.exception.UnboundedException;
import uniol.apt.analysis.fc.FreeChoice;
import uniol.apt.analysis.isolated.Isolated;
import uniol.apt.analysis.live.Live;
import uniol.apt.analysis.persistent.PersistentNet;
import uniol.apt.analysis.plain.Plain;
import uniol.apt.analysis.reversible.ReversibleNet;
import uniol.apt.analysis.separation.LargestK;
import uniol.apt.analysis.separation.SeparationLogic;
import uniol.apt.analysis.sideconditions.Pure;
import uniol.apt.analysis.snet.SNet;
import uniol.apt.analysis.tnet.TNet;
import uniol.apt.check.AttributeFormatException;
import uniol.apt.check.UnsupportedAttributeException;

public class CheckAttributes {
    private PetriNet petriNet;
    private Set<String> attributes = new HashSet<String>();
    private int score;
    private int markingFactor = 1;
    private boolean finished;
    private int bestScore = 0;
    private String bestMatch = null;

    CheckAttributes() {
    }

    public void setPetriNet(PetriNet petriNet) {
        this.petriNet = petriNet;
    }

    /*
     * Unable to fully structure code
     */
    public void check() throws AttributeFormatException, UnsupportedAttributeException {
        match = new StringBuilder("\n");
        tempScore = 0;
        this.score = 0;
        this.markingFactor = 1;
        for (String attribute : this.attributes) {
            if (attribute.equals("snet")) {
                if (this.checkSnet()) {
                    ++this.score;
                }
            } else if (attribute.equals("!snet")) {
                if (!this.checkSnet()) {
                    ++this.score;
                }
            } else if (attribute.equals("tnet")) {
                if (this.checkTnet()) {
                    ++this.score;
                }
            } else if (attribute.equals("!tnet")) {
                if (!this.checkTnet()) {
                    ++this.score;
                }
            } else if (attribute.equals("freeChoice")) {
                if (this.checkFreeChoice()) {
                    ++this.score;
                }
            } else if (attribute.equals("!freeChoice")) {
                if (!this.checkFreeChoice()) {
                    ++this.score;
                }
            } else if (attribute.equals("pure")) {
                if (this.checkPure()) {
                    ++this.score;
                }
            } else if (attribute.equals("!pure")) {
                if (!this.checkPure()) {
                    ++this.score;
                }
            } else if (attribute.equals("isolated")) {
                if (this.checkIsolated()) {
                    ++this.score;
                }
            } else if (attribute.equals("!isolated")) {
                if (!this.checkIsolated()) {
                    ++this.score;
                }
            } else if (attribute.equals("plain")) {
                if (this.checkPlain()) {
                    ++this.score;
                }
            } else if (attribute.equals("!plain")) {
                if (!this.checkPlain()) {
                    ++this.score;
                }
            } else if (attribute.equals("bounded")) {
                if (this.checkBounded()) {
                    ++this.score;
                }
            } else if (attribute.equals("!bounded")) {
                if (!this.checkBounded()) {
                    ++this.score;
                }
            } else if (attribute.equals("stronglyLive")) {
                if (this.checkStronglyLive()) {
                    ++this.score;
                }
            } else if (attribute.equals("!stronglyLive")) {
                if (!this.checkStronglyLive()) {
                    ++this.score;
                }
            } else if (attribute.equals("reversible")) {
                if (this.checkReversible()) {
                    ++this.score;
                }
            } else if (attribute.equals("!reversible")) {
                if (!this.checkReversible()) {
                    ++this.score;
                }
            } else if (attribute.equals("persistent")) {
                if (this.checkPersistent()) {
                    ++this.score;
                }
            } else if (attribute.equals("!persistent")) {
                if (!this.checkPersistent()) {
                    ++this.score;
                }
            } else if (attribute.endsWith("-marking")) {
                numberStartIndex = 0;
                if (attribute.charAt(0) == '!') {
                    ++numberStartIndex;
                }
                numberEndIndex = attribute.indexOf(45);
                try {
                    k = Integer.parseInt(attribute.substring(numberStartIndex, numberEndIndex));
                    if (attribute.charAt(0) == '!') {
                        if (this.checkKMarking(k)) ** GOTO lbl124
                        ++this.score;
                    }
                    if (this.markingFactor % k != 0) {
                        this.markingFactor *= k;
                    }
                    if (!this.checkKMarking(k)) ** GOTO lbl124
                    ++this.score;
                }
                catch (NumberFormatException e) {
                    throw new AttributeFormatException(attribute);
                }
            } else if (attribute.endsWith("-separable")) {
                if (attribute.startsWith("!strongly_")) {
                    stronglyCheck = true;
                } else if (attribute.startsWith("!weakly_")) {
                    stronglyCheck = false;
                } else {
                    throw new AttributeFormatException(attribute);
                }
                numberStartIndex = attribute.indexOf(95) + 1;
                numberEndIndex = attribute.indexOf(45);
                try {
                    k = Integer.parseInt(attribute.substring(numberStartIndex, numberEndIndex));
                    if (this.markingFactor % k != 0) {
                        this.markingFactor *= k;
                    }
                    if (!this.checkNotkSeparable(stronglyCheck, k, 5)) ** GOTO lbl124
                    ++this.score;
                }
                catch (NumberFormatException e) {
                    throw new AttributeFormatException(attribute);
                }
            } else {
                throw new UnsupportedAttributeException(attribute);
            }
lbl124:
            // 26 sources

            if (this.score <= tempScore) continue;
            match.append(attribute + " ");
            tempScore = this.score;
        }
        this.finished = this.score == this.attributes.size();
        if (this.score > this.bestScore) {
            this.bestMatch = match.toString();
            this.bestScore = this.score;
        }
    }

    private boolean checkSnet() {
        SNet sNet = new SNet(this.petriNet);
        try {
            return sNet.testPlainSNet();
        }
        catch (PreconditionFailedException e) {
            return false;
        }
    }

    private boolean checkTnet() {
        TNet tNet = new TNet(this.petriNet);
        try {
            return tNet.testPlainTNet();
        }
        catch (PreconditionFailedException e) {
            return false;
        }
    }

    private boolean checkFreeChoice() {
        try {
            FreeChoice fc = new FreeChoice();
            return fc.check(this.petriNet);
        }
        catch (PreconditionFailedException ex) {
            return false;
        }
    }

    private boolean checkPure() {
        return Pure.checkPure(this.petriNet);
    }

    private boolean checkIsolated() {
        return Isolated.checkIsolated(this.petriNet);
    }

    private boolean checkPlain() {
        Plain plain = new Plain();
        return plain.checkPlain(this.petriNet);
    }

    private boolean checkBounded() {
        return Bounded.isBounded(this.petriNet);
    }

    private boolean checkStronglyLive() {
        boolean boolLive = true;
        for (Transition t : this.petriNet.getTransitions()) {
            try {
                boolLive &= Live.checkStronglyLive(this.petriNet, t);
            }
            catch (UnboundedException e) {
                return false;
            }
        }
        return boolLive;
    }

    private boolean checkReversible() {
        ReversibleNet reversible = new ReversibleNet(this.petriNet);
        try {
            reversible.check();
        }
        catch (UnboundedException e) {
            return false;
        }
        return reversible.isReversible();
    }

    private boolean checkPersistent() {
        PersistentNet persistent = new PersistentNet(this.petriNet);
        try {
            persistent.check();
        }
        catch (UnboundedException e) {
            return false;
        }
        return persistent.isPersistent();
    }

    private boolean checkKMarking(long k) {
        LargestK largestK = new LargestK(this.petriNet);
        long maxK = largestK.computeLargestK();
        return maxK % k == 0L;
    }

    private boolean checkNotkSeparable(boolean stronglyCheck, long k, int maxLength) {
        try {
            LargestK largestK = new LargestK(this.petriNet);
            long maxK = largestK.computeLargestK();
            if (maxK % k != 0L) {
                return false;
            }
            SeparationLogic separationLogic = new SeparationLogic(this.petriNet, stronglyCheck, k, null, maxLength, false);
            return !separationLogic.getResult().isSeparable();
        }
        catch (UnboundedException e) {
            return false;
        }
    }

    public Set<String> getAttributes() {
        return this.attributes;
    }

    public void addAttribute(String attribute) {
        this.attributes.add(attribute);
    }

    public int getScore() {
        return this.score;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public int getMarkingFactor() {
        return this.markingFactor;
    }

    public void setMarkingFactor(int markingFactor) {
        this.markingFactor = markingFactor;
    }

    public String getBestMatch() {
        return this.bestMatch;
    }
}

