/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.check;

import uniol.apt.adt.pn.PetriNet;
import uniol.apt.check.AttributeFormatException;
import uniol.apt.check.CheckAttributes;
import uniol.apt.check.CheckGenerator;
import uniol.apt.check.CheckParameters;
import uniol.apt.check.UnsupportedAttributeException;
import uniol.apt.check.UnsupportedGeneratorException;

public class Check {
    private PetriNet pn = null;
    private int counter;
    private CheckGenerator generator = new CheckGenerator();
    private CheckAttributes attributes = new CheckAttributes();
    private CheckParameters parameters = new CheckParameters();

    public void addAttribute(String attribute) throws UnsupportedAttributeException {
        this.attributes.addAttribute(attribute);
    }

    public void setGenerator(String name) throws UnsupportedGeneratorException {
        this.generator.setGenerator(name);
        this.generator.setInitialParameters(this.parameters);
    }

    public PetriNet search(int maxSeconds) throws AttributeFormatException, UnsupportedAttributeException {
        boolean found = false;
        long startTimestamp = System.currentTimeMillis();
        this.counter = 0;
        while (!found) {
            this.pn = this.generator.getPNs();
            long timestamp = System.currentTimeMillis();
            if (timestamp - startTimestamp > (long)(maxSeconds * 1000)) {
                return null;
            }
            if (this.pn != null) {
                this.attributes.setPetriNet(this.pn);
                this.attributes.check();
            }
            this.parameters.modify(this.attributes.getScore(), this.attributes.getMarkingFactor());
            found = this.attributes.isFinished();
            ++this.counter;
        }
        return this.pn;
    }

    public PetriNet getPn() {
        return this.pn;
    }

    public void setPn(PetriNet pn) {
        this.pn = pn;
    }

    public String getBestMatch() {
        return this.attributes.getBestMatch();
    }

    public int getCounter() {
        return this.counter;
    }
}

