/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.check;

import java.util.HashSet;
import uniol.apt.adt.pn.Flow;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.adt.pn.Transition;

public class ChanceGenerator {
    PetriNet pn;
    int modificationCounter = 0;
    int transitionCounter;
    int placeCounter;
    int lastScore = 0;
    int markingValue;

    public PetriNet generateNet(int value, int initMarkingValue) {
        this.markingValue = Math.abs(initMarkingValue);
        if (value > this.lastScore) {
            this.modifyNet();
            this.modificationCounter = 0;
        } else if (value == this.lastScore) {
            if (this.modificationCounter < 5) {
                this.modifyNet();
            } else {
                this.renewNet();
            }
        } else {
            this.renewNet();
        }
        this.lastScore = value;
        return this.pn;
    }

    public void renewNet() {
        this.modificationCounter = 0;
        this.lastScore = 0;
        this.pn = new PetriNet();
        Place p1 = this.pn.createPlace("p1");
        p1.setInitialToken(this.markingValue);
        Place p2 = this.pn.createPlace("p2");
        Transition t1 = this.pn.createTransition("t1");
        this.pn.createFlow(p1, t1);
        this.pn.createFlow(t1, p2);
        this.placeCounter = 2;
        this.transitionCounter = 1;
        long incrementSize = Math.round(3.0 + (Math.random() - 0.5) * 6.0);
        int i = 0;
        while ((long)i < incrementSize) {
            double magic = Math.random();
            if (magic < 0.5) {
                this.addPlace();
            } else {
                this.addTransition();
            }
            ++i;
        }
    }

    public void modifyNet() {
        double magic = Math.random();
        if (magic < 0.2) {
            this.addPlace();
        } else if (magic < 0.3) {
            this.addMarks();
        } else if (magic < 0.35) {
            this.addWeight();
        } else if (magic < 0.7) {
            this.addTransition();
        } else {
            this.removeTransition();
        }
        ++this.modificationCounter;
    }

    private void addMarks() {
        double addChance = 1.0 / (double)this.pn.getPlaces().size();
        for (Place place : this.pn.getPlaces()) {
            double addDelete = Math.random();
            if (!(addDelete < addChance)) continue;
            place.setInitialToken(this.markingValue);
        }
    }

    private void addWeight() {
        double addChance = 1.0 / (double)this.pn.getEdges().size();
        for (Flow arc : this.pn.getEdges()) {
            double addWeight = Math.random();
            int weight = (int)Math.round(2.0 + (Math.random() - 0.5) * 2.0);
            if (!(addWeight < addChance)) continue;
            arc.setWeight(weight);
        }
    }

    private void addPlace() {
        ++this.placeCounter;
        String name = "p" + this.placeCounter;
        Place p = this.pn.createPlace(name);
        p.setInitialToken(0L);
        double arcChance = 1.0 / (double)this.pn.getTransitions().size();
        for (Transition transition : this.pn.getTransitions()) {
            double randomValueTo = Math.random();
            double randomValueFrom = Math.random();
            if (randomValueTo < arcChance) {
                this.pn.createFlow(transition, p);
            }
            if (!(randomValueFrom < arcChance)) continue;
            this.pn.createFlow(p, transition);
        }
    }

    private void addTransition() {
        ++this.transitionCounter;
        String name = "t" + this.transitionCounter;
        Transition t = this.pn.createTransition(name);
        double arcChance = 1.0 / (double)this.pn.getPlaces().size();
        for (Place place : this.pn.getPlaces()) {
            double randomValueTo = Math.random();
            double randomValueFrom = Math.random();
            if (randomValueTo < arcChance) {
                this.pn.createFlow(place, t);
            }
            if (!(randomValueFrom < arcChance)) continue;
            this.pn.createFlow(t, place);
        }
    }

    private void removeTransition() {
        double deleteChance = 1.0 / (double)this.pn.getTransitions().size();
        HashSet<Transition> toRemove = new HashSet<Transition>();
        for (Transition transition : this.pn.getTransitions()) {
            double randomDelete = Math.random();
            if (!(randomDelete < deleteChance)) continue;
            toRemove.add(transition);
        }
        for (Transition transition : toRemove) {
            this.pn.removeTransition(transition);
        }
    }
}

