/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.trapsAndSiphons;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.sat4j.core.ReadOnlyVecInt;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.opt.MinOneDecorator;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.OptToSatAdapter;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.adt.pn.Transition;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class TrapsAndSiphonsLogic {
    private ArrayList<Place> placesList;
    private ArrayList<VecInt> clauses;
    private Set<Set<Place>> result;
    private boolean searchForTraps;
    private boolean searchForSiphons;

    public TrapsAndSiphonsLogic(PetriNet pn, boolean siphons, boolean traps) {
        block6: {
            this.clauses = new ArrayList();
            this.result = new HashSet<Set<Place>>();
            if (siphons) {
                this.searchForSiphons = siphons;
            } else if (traps && !siphons) {
                this.searchForTraps = traps;
            }
            this.placesList = new ArrayList<Place>(pn.getPlaces());
            try {
                this.start();
            }
            catch (ContradictionException contradictionException) {
            }
            catch (TimeoutException e) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError((Object)"We set no timeout and thus timeouts cannot occur");
            }
        }
    }

    private void start() throws ContradictionException, TimeoutException {
        this.computeCNF(this.placesList);
        while (true) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            OptToSatAdapter solver = new OptToSatAdapter(new MinOneDecorator(SolverFactory.newDefault()));
            for (VecInt clause : this.clauses) {
                solver.addClause(new ReadOnlyVecInt(clause));
            }
            if (!solver.isSatisfiable()) break;
            int[] model = solver.model();
            HashSet<Place> tempSet = new HashSet<Place>();
            for (int i : model) {
                if (i <= 0) continue;
                tempSet.add(this.placesList.get(i - 1));
            }
            this.result.add(tempSet);
            int[] exclude = new int[]{};
            for (int i = 0; i < model.length; ++i) {
                if (model[i] <= 0) continue;
                exclude = Arrays.copyOf(exclude, exclude.length + 1);
                exclude[exclude.length - 1] = -model[i];
            }
            assert (exclude.length > 0);
            this.clauses.add(new VecInt(exclude));
        }
        this.setResult(this.result);
    }

    private void computeCNF(ArrayList<Place> placesList) {
        block8: {
            int i;
            block7: {
                int[] excludeEmptyClause = new int[placesList.size()];
                for (i = 1; i <= placesList.size(); ++i) {
                    excludeEmptyClause[i - 1] = i;
                }
                this.clauses.add(new VecInt(excludeEmptyClause));
                if (!this.searchForSiphons) break block7;
                for (i = 1; i <= placesList.size(); ++i) {
                    for (Transition t : placesList.get(i - 1).getPreset()) {
                        InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                        int[] clausel = new int[t.getPreset().size() + 1];
                        clausel[0] = -i;
                        int j = 1;
                        for (Place p : t.getPreset()) {
                            clausel[j++] = placesList.indexOf(p) + 1;
                        }
                        this.clauses.add(new VecInt(clausel));
                    }
                }
                break block8;
            }
            if (!this.searchForTraps) break block8;
            for (i = 1; i <= placesList.size(); ++i) {
                for (Transition t : placesList.get(i - 1).getPostset()) {
                    InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                    int[] clausel = new int[t.getPostset().size() + 1];
                    clausel[0] = -i;
                    int j = 1;
                    for (Place p : t.getPostset()) {
                        clausel[j++] = placesList.indexOf(p) + 1;
                    }
                    this.clauses.add(new VecInt(clausel));
                }
            }
        }
    }

    public Set<Set<Place>> getResult() {
        return this.result;
    }

    public void setResult(Set<Set<Place>> result) {
        this.result = result;
    }
}

