/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.trapsAndSiphons;

import java.util.Collection;
import java.util.Set;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.analysis.trapsAndSiphons.TrapsAndSiphonsLogic;
import uniol.apt.analysis.trapsAndSiphons.TrapsSiphonsList;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class SiphonModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getShortDescription() {
        return "Compute all minimal siphons in a Petri net";
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription() + ". A siphon is a set of places so that every transition consuming tokens from one of these places also produces tokens on at least one place in the set.";
    }

    @Override
    public String getName() {
        return "siphons";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("pn", PetriNet.class, "The Petri net that should be examined", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("minimal_siphons", TrapsSiphonsList.class, new String[0]);
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        PetriNet pn = input.getParameter("pn", PetriNet.class);
        TrapsAndSiphonsLogic logic = new TrapsAndSiphonsLogic(pn, true, false);
        output.setReturnValue("minimal_siphons", TrapsSiphonsList.class, new TrapsSiphonsList((Collection<? extends Set<Place>>)logic.getResult()));
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN};
    }
}

