/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.totallyreachable;

import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.totallyreachable.TotallyReachable;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class TotallyReachableModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getName() {
        return "totally_reachable";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("lts", TransitionSystem.class, "The LTS that should be examined", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("totally_reachable", Boolean.class, "totally_reachable", "success");
        outputSpec.addReturnValue("state", State.class, new String[0]);
        outputSpec.addReturnValue("label", String.class, new String[0]);
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        TransitionSystem ts = input.getParameter("lts", TransitionSystem.class);
        TotallyReachable totallyReachable = new TotallyReachable(ts);
        output.setReturnValue("totally_reachable", Boolean.class, totallyReachable.isTotallyReachable());
        output.setReturnValue("state", State.class, totallyReachable.getNode());
        if (!totallyReachable.isTotallyReachable()) {
            output.setReturnValue("label", String.class, totallyReachable.getLabel());
        }
    }

    @Override
    public String getTitle() {
        return "Check total reachability";
    }

    @Override
    public String getShortDescription() {
        return "Check if the given LTS is totally reachable";
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.LTS};
    }
}

