/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.totallyreachable;

import java.util.HashSet;
import java.util.Iterator;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.util.SpanningTree;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class TotallyReachable {
    private final State unreachableState;

    public TotallyReachable(TransitionSystem ts, Algorithm algo) {
        switch (algo) {
            case SEARCH: {
                HashSet<State> stillToVisit = new HashSet<State>();
                HashSet<State> unreached = new HashSet<State>(ts.getNodes());
                stillToVisit.add(ts.getInitialState());
                unreached.remove(ts.getInitialState());
                while (!stillToVisit.isEmpty()) {
                    InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                    Iterator iter = stillToVisit.iterator();
                    State state = (State)iter.next();
                    iter.remove();
                    for (State follower : state.getPostsetNodes()) {
                        if (!unreached.remove(follower)) continue;
                        stillToVisit.add(follower);
                    }
                }
                if (unreached.isEmpty()) {
                    this.unreachableState = null;
                    break;
                }
                this.unreachableState = (State)unreached.iterator().next();
                break;
            }
            case SPANNING_TREE: {
                SpanningTree tree = SpanningTree.get(ts, ts.getInitialState());
                if (tree.isTotallyReachable()) {
                    this.unreachableState = null;
                    break;
                }
                this.unreachableState = tree.getUnreachableNodes().iterator().next();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public TotallyReachable(TransitionSystem ts) {
        this(ts, Algorithm.SPANNING_TREE);
    }

    public boolean isTotallyReachable() {
        return this.unreachableState == null;
    }

    public String getLabel() {
        return this.unreachableState != null ? this.unreachableState.getId() : null;
    }

    public State getNode() {
        return this.unreachableState;
    }

    public static enum Algorithm {
        SEARCH,
        SPANNING_TREE;

    }
}

