/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.tnet;

import uniol.apt.adt.pn.PetriNet;
import uniol.apt.analysis.tnet.TNet;
import uniol.apt.analysis.tnet.TNetResult;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class TNetModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getName() {
        return "tnet";
    }

    @Override
    public String getTitle() {
        return "T-Net";
    }

    @Override
    public String getShortDescription() {
        return "Check if a plain Petri net is a T-net";
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription() + ". In a T-net, the preset and postset of any place has at most one entry (plus the net is plain).";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("pn", PetriNet.class, "The Petri net that should be examined", "plain");
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("t_net", Boolean.class, "success");
        outputSpec.addReturnValue("information", TNetResult.class, new String[0]);
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        PetriNet pn = input.getParameter("pn", PetriNet.class);
        TNet tnet = new TNet(pn);
        boolean returnValue = tnet.testPlainTNet();
        TNetResult result = tnet.getResult();
        output.setReturnValue("t_net", Boolean.class, returnValue);
        output.setReturnValue("information", TNetResult.class, result);
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN};
    }
}

