/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.tnet;

import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.analysis.exception.PreconditionFailedException;
import uniol.apt.analysis.plain.Plain;
import uniol.apt.analysis.tnet.TNetResult;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class TNet {
    private final PetriNet petriNet;
    private TNetResult result;

    public TNet(PetriNet petriNet) {
        this.petriNet = petriNet;
        this.result = new TNetResult();
    }

    public boolean testPlainTNet() throws PreconditionFailedException {
        if (!new Plain().checkPlain(this.petriNet)) {
            throw new PreconditionFailedException("the net is not plain.");
        }
        for (Place place : this.petriNet.getPlaces()) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            if (place.getPreset().size() > 1) {
                this.result.addMergeID(place.getId());
                this.result.setTNet(false);
            }
            if (place.getPostset().size() <= 1) continue;
            this.result.addConflictID(place.getId());
            this.result.setTNet(false);
        }
        return this.result.isTNet();
    }

    public TNetResult getResult() {
        return this.result;
    }
}

