/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.synthesize.separation;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import uniol.apt.adt.exception.StructureException;
import uniol.apt.adt.ts.Event;
import uniol.apt.adt.ts.State;
import uniol.apt.analysis.synthesize.MissingLocationException;
import uniol.apt.analysis.synthesize.PNProperties;
import uniol.apt.analysis.synthesize.Region;
import uniol.apt.analysis.synthesize.RegionUtility;
import uniol.apt.analysis.synthesize.UnreachableException;
import uniol.apt.analysis.synthesize.separation.BasicImpureSeparation;
import uniol.apt.analysis.synthesize.separation.BasicPureSeparation;
import uniol.apt.analysis.synthesize.separation.ElementarySeparation;
import uniol.apt.analysis.synthesize.separation.FactorisationSynthesizer;
import uniol.apt.analysis.synthesize.separation.InequalitySystemSeparation;
import uniol.apt.analysis.synthesize.separation.KBoundedSeparation;
import uniol.apt.analysis.synthesize.separation.MarkedGraphSeparation;
import uniol.apt.analysis.synthesize.separation.OutputNonbranchingSeparation;
import uniol.apt.analysis.synthesize.separation.PlainPureSeparation;
import uniol.apt.analysis.synthesize.separation.Separation;
import uniol.apt.analysis.synthesize.separation.SeparationSynthesizer;
import uniol.apt.analysis.synthesize.separation.Synthesizer;
import uniol.apt.analysis.synthesize.separation.UnsupportedPNPropertiesException;
import uniol.apt.util.DebugUtil;

public final class SeparationUtility {
    private SeparationUtility() {
    }

    public static boolean isEventEnabled(State state, String event) {
        return !state.getPostsetNodesByLabel(event).isEmpty();
    }

    public static boolean isSeparatingRegion(Region region, State state, State otherState) {
        try {
            BigInteger stateValue = region.getMarkingForState(state);
            BigInteger otherStateValue = region.getMarkingForState(otherState);
            return !stateValue.equals(otherStateValue);
        }
        catch (UnreachableException e) {
            return false;
        }
    }

    public static boolean isSeparatingRegion(Region region, State state, String event) {
        try {
            return region.getMarkingForState(state).compareTo(region.getBackwardWeight(event)) < 0;
        }
        catch (UnreachableException e) {
            return false;
        }
    }

    public static String[] getLocationMap(RegionUtility utility, PNProperties properties) throws MissingLocationException {
        String[] locationMap = new String[utility.getNumberOfEvents()];
        boolean hadEventWithLocation = false;
        if (locationMap.length == 0) {
            return locationMap;
        }
        for (Event eventObj : utility.getTransitionSystem().getAlphabetEvents()) {
            String location;
            try {
                location = eventObj.getExtension("location").toString();
            }
            catch (StructureException e) {
                continue;
            }
            int event = utility.getEventIndex(eventObj.getLabel());
            String oldLocation = locationMap[event];
            locationMap[event] = location;
            hadEventWithLocation = true;
            assert (oldLocation == null || oldLocation.equals(location));
        }
        if (hadEventWithLocation && Arrays.asList(locationMap).contains(null)) {
            throw new MissingLocationException("Trying to synthesize a Petri Net where some events  have a location and others do not. Either all or no event must have a location.");
        }
        if (properties.isOutputNonbranching()) {
            for (int i = 0; i < locationMap.length; ++i) {
                locationMap[i] = String.valueOf(i);
            }
        }
        if (Collections.frequency(Arrays.asList(locationMap), locationMap[0]) == locationMap.length) {
            locationMap = new String[locationMap.length];
        }
        return locationMap;
    }

    public static Separation createSeparationInstance(RegionUtility utility, PNProperties properties) throws MissingLocationException {
        String[] locationMap = SeparationUtility.getLocationMap(utility, properties);
        properties = properties.setOutputNonbranching(false);
        return SeparationUtility.createSeparationInstanceInternal(utility, properties, locationMap);
    }

    private static Separation createSeparationInstanceInternal(RegionUtility utility, PNProperties properties, String[] locationMap) {
        Separation result = null;
        String forcedSeparationImplementation = System.getProperty("apt.separationImplementation");
        if (forcedSeparationImplementation != null) {
            result = SeparationUtility.createInstance(Separation.class, forcedSeparationImplementation, new Object[]{utility, properties, locationMap}, new Class[]{RegionUtility.class, PNProperties.class, String[].class});
        }
        try {
            if (result == null) {
                result = new ElementarySeparation(utility, properties, locationMap);
            }
        }
        catch (UnsupportedPNPropertiesException unsupportedPNPropertiesException) {
            // empty catch block
        }
        try {
            if (result == null) {
                result = new KBoundedSeparation(utility, properties, locationMap);
            }
        }
        catch (UnsupportedPNPropertiesException unsupportedPNPropertiesException) {
            // empty catch block
        }
        try {
            if (result == null) {
                result = new BasicPureSeparation(utility, properties, locationMap);
            }
        }
        catch (UnsupportedPNPropertiesException unsupportedPNPropertiesException) {
            // empty catch block
        }
        try {
            if (result == null) {
                result = new BasicImpureSeparation(utility, properties, locationMap);
            }
        }
        catch (UnsupportedPNPropertiesException unsupportedPNPropertiesException) {
            // empty catch block
        }
        try {
            if (result == null) {
                result = new PlainPureSeparation(utility, properties, locationMap);
            }
        }
        catch (UnsupportedPNPropertiesException unsupportedPNPropertiesException) {
            // empty catch block
        }
        if (result == null) {
            result = new InequalitySystemSeparation(utility, properties, locationMap);
        }
        DebugUtil.debug((Object)"Created Separation instance from class ", (Object)result.getClass().getName());
        return result;
    }

    public static Synthesizer createSynthesizerInstance(RegionUtility utility, PNProperties properties, boolean onlyEventSeparation, boolean quickFail, Collection<Region> regions) throws MissingLocationException {
        boolean tryToFactorize = !Boolean.getBoolean("apt.separation.skipFactorisation");
        return SeparationUtility.createSynthesizerInstance(utility, properties, onlyEventSeparation, quickFail, regions, tryToFactorize);
    }

    public static Synthesizer createSynthesizerInstance(RegionUtility utility, PNProperties properties, boolean onlyEventSeparation, boolean quickFail, Collection<Region> regions, boolean tryToFactorize) throws MissingLocationException {
        Synthesizer result;
        if (quickFail && tryToFactorize && (result = new FactorisationSynthesizer().createSynthesizer(utility, properties, onlyEventSeparation)) != null) {
            return result;
        }
        String[] locationMap = SeparationUtility.getLocationMap(utility, properties);
        properties = properties.setOutputNonbranching(false);
        Synthesizer result2 = null;
        String forcedSynthesizerImplementation = System.getProperty("apt.synthesizerImplementation");
        if (forcedSynthesizerImplementation != null) {
            result2 = SeparationUtility.createInstance(Synthesizer.class, forcedSynthesizerImplementation, new Object[]{utility, properties, locationMap}, new Class[]{RegionUtility.class, PNProperties.class, String[].class});
        }
        try {
            if (result2 == null) {
                result2 = new MarkedGraphSeparation(utility, properties, locationMap);
            }
        }
        catch (UnsupportedPNPropertiesException unsupportedPNPropertiesException) {
            // empty catch block
        }
        try {
            if (result2 == null) {
                result2 = new OutputNonbranchingSeparation(utility, properties, locationMap);
            }
        }
        catch (OutputNonbranchingSeparation.UnsolvableESSPInstanceException e) {
            if (quickFail) {
                result2 = new UnsolvableESSPInstanceSynthesizer(e.getState(), e.getEvent());
            }
        }
        catch (UnsupportedPNPropertiesException e) {
            // empty catch block
        }
        if (result2 != null) {
            DebugUtil.debug((Object)"Created Synthesizer instance from class ", (Object)result2.getClass().getName());
            return result2;
        }
        Separation sep = SeparationUtility.createSeparationInstanceInternal(utility, properties, locationMap);
        if (sep instanceof Synthesizer) {
            return (Synthesizer)((Object)sep);
        }
        return new SeparationSynthesizer(utility.getTransitionSystem(), sep, onlyEventSeparation, quickFail, regions);
    }

    private static <T> T createInstance(Class<T> interfac, String klassName, Object[] parameters, Class<?>[] parameterTypes) {
        try {
            Class<?> klass;
            String pkg = SeparationUtility.class.getPackage().getName();
            try {
                klass = Class.forName(pkg + "." + klassName);
            }
            catch (ClassNotFoundException e) {
                klass = Class.forName(klassName);
            }
            Constructor<?> constructor = klass.getConstructor(parameterTypes);
            return interfac.cast(constructor.newInstance(parameters));
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Failed to instantiate " + klassName + " as an implementation of " + interfac, e.getTargetException());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate " + klassName + " as an implementation of " + interfac, e);
        }
    }

    private static class UnsolvableESSPInstanceSynthesizer
    implements Synthesizer {
        private final State state;
        private final String event;

        private UnsolvableESSPInstanceSynthesizer(State state, String event) {
            this.state = state;
            this.event = event;
        }

        @Override
        public Collection<Region> getSeparatingRegions() {
            return Collections.emptySet();
        }

        @Override
        public Map<String, Set<State>> getUnsolvableEventStateSeparationProblems() {
            return Collections.singletonMap(this.event, Collections.singleton(this.state));
        }

        @Override
        public Collection<Set<State>> getUnsolvableStateSeparationProblems() {
            return Collections.emptySet();
        }
    }
}

