/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.synthesize.separation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.synthesize.Region;
import uniol.apt.analysis.synthesize.SynthesizePN;
import uniol.apt.analysis.synthesize.separation.Separation;
import uniol.apt.analysis.synthesize.separation.SeparationUtility;
import uniol.apt.analysis.synthesize.separation.Synthesizer;
import uniol.apt.util.DebugUtil;
import uniol.apt.util.DifferentPairsIterable;
import uniol.apt.util.EquivalenceRelation;
import uniol.apt.util.Pair;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class SeparationSynthesizer
implements Synthesizer {
    private final Collection<Region> separatingRegions;
    private final Map<String, Set<State>> unsolvableESSP;
    private final Collection<Set<State>> unsolvableSSP;

    public SeparationSynthesizer(TransitionSystem ts, Separation separation, boolean onlyEventSeparation, boolean quickFail, Collection<Region> knownRegions) {
        HashSet<Region> regions = new HashSet<Region>();
        if (knownRegions != null) {
            regions.addAll(knownRegions);
        }
        HashMap<String, Set<State>> essp = new HashMap<String, Set<State>>();
        EquivalenceRelation<State> ssp = new EquivalenceRelation<State>();
        this.solveEventStateSeparation(ts, separation, quickFail, regions, essp);
        if (!(onlyEventSeparation || quickFail && !essp.isEmpty())) {
            this.solveStateSeparation(ts, separation, quickFail, regions, ssp);
        }
        if (!quickFail || essp.isEmpty() && ssp.isEmpty()) {
            this.minimizeRegions(ts, regions, onlyEventSeparation);
        }
        this.separatingRegions = Collections.unmodifiableSet(regions);
        this.unsolvableESSP = Collections.unmodifiableMap(essp);
        this.unsolvableSSP = Collections.unmodifiableCollection(ssp);
        DebugUtil.debug();
    }

    private void solveEventStateSeparation(TransitionSystem ts, Separation separation, boolean quickFail, Set<Region> regions, Map<String, Set<State>> failedProblems) {
        DebugUtil.debug();
        DebugUtil.debug("Solving event-state separation");
        for (State state : ts.getNodes()) {
            for (String event : ts.getAlphabet()) {
                InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                if (SeparationUtility.isEventEnabled(state, event)) continue;
                DebugUtil.debugFormat("Trying to separate %s from event '%s'", state, event);
                Region r = null;
                for (Region region : regions) {
                    if (!SeparationUtility.isSeparatingRegion(region, state, event)) continue;
                    r = region;
                    break;
                }
                if (r != null) {
                    DebugUtil.debug((Object)"Found region ", r);
                    continue;
                }
                r = separation.calculateSeparatingRegion(state, event);
                if (r == null) {
                    Set<State> set = failedProblems.get(event);
                    if (set == null) {
                        set = new HashSet<State>();
                        failedProblems.put(event, set);
                    }
                    set.add(state);
                    DebugUtil.debug("Failure!");
                    if (!quickFail) continue;
                    return;
                }
                DebugUtil.debug((Object)"Calculated region ", (Object)r);
                regions.add(r);
            }
        }
    }

    private void solveStateSeparation(TransitionSystem ts, Separation separation, boolean quickFail, Set<Region> regions, EquivalenceRelation<State> failedStateSeparationRelation) {
        DebugUtil.debug();
        DebugUtil.debug("Solving state separation");
        for (Pair<State, State> pair : new DifferentPairsIterable<State>(SynthesizePN.calculateUnseparatedStates(ts.getNodes(), regions))) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            State state = pair.getFirst();
            State otherState = pair.getSecond();
            DebugUtil.debugFormat("Trying to separate %s from %s", state, otherState);
            Region r = null;
            for (Region region : regions) {
                if (!SeparationUtility.isSeparatingRegion(region, state, otherState)) continue;
                r = region;
                break;
            }
            if (r != null) {
                DebugUtil.debug((Object)"Found region ", r);
                continue;
            }
            r = separation.calculateSeparatingRegion(state, otherState);
            if (r == null) {
                failedStateSeparationRelation.joinClasses(state, otherState);
                DebugUtil.debug("Failure!");
                if (!quickFail) continue;
                return;
            }
            DebugUtil.debug((Object)"Calculated region ", (Object)r);
            regions.add(r);
        }
    }

    private void minimizeRegions(TransitionSystem ts, Set<Region> regions, boolean onlyEventSeparation) {
        DebugUtil.debug();
        DebugUtil.debug("Minimizing regions");
        SynthesizePN.minimizeRegions(ts, regions, onlyEventSeparation);
    }

    @Override
    public Collection<Region> getSeparatingRegions() {
        return this.separatingRegions;
    }

    @Override
    public Map<String, Set<State>> getUnsolvableEventStateSeparationProblems() {
        return this.unsolvableESSP;
    }

    @Override
    public Collection<Set<State>> getUnsolvableStateSeparationProblems() {
        return this.unsolvableSSP;
    }
}

