/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.synthesize.separation;

import java.math.BigInteger;
import java.util.ArrayList;
import uniol.apt.analysis.synthesize.PNProperties;
import uniol.apt.analysis.synthesize.Region;
import uniol.apt.analysis.synthesize.RegionUtility;
import uniol.apt.analysis.synthesize.separation.BasicPureSeparation;
import uniol.apt.analysis.synthesize.separation.Separation;
import uniol.apt.analysis.synthesize.separation.UnsupportedPNPropertiesException;
import uniol.apt.util.equations.InequalitySystem;

class PlainPureSeparation
extends BasicPureSeparation
implements Separation {
    protected PlainPureSeparation(RegionUtility utility, String[] locationMap) {
        super(utility, locationMap);
    }

    public PlainPureSeparation(RegionUtility utility, PNProperties properties, String[] locationMap) throws UnsupportedPNPropertiesException {
        this(utility, locationMap);
        PNProperties supported = new PNProperties().setPure(true).setPlain(true);
        if (!properties.equals(supported)) {
            throw new UnsupportedPNPropertiesException();
        }
    }

    @Override
    protected InequalitySystem prepareInequalitySystem() {
        InequalitySystem system = new InequalitySystem();
        for (int event = 0; event < this.utility.getNumberOfEvents(); ++event) {
            ArrayList<BigInteger> inequality = new ArrayList<BigInteger>();
            for (Region region : this.utility.getRegionBasis()) {
                inequality.add(region.getWeight(event));
            }
            system.addInequality(1, ">=", inequality, "Plain for event " + event);
            system.addInequality(-1, "<=", inequality, "Plain for event " + event);
        }
        return system;
    }
}

