/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.synthesize.separation;

import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uniol.apt.adt.ts.Arc;
import uniol.apt.adt.ts.ParikhVector;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.cycles.CycleSearchViaChords;
import uniol.apt.analysis.exception.PreconditionFailedException;
import uniol.apt.analysis.synthesize.PNProperties;
import uniol.apt.analysis.synthesize.Region;
import uniol.apt.analysis.synthesize.RegionUtility;
import uniol.apt.analysis.synthesize.separation.Separation;
import uniol.apt.analysis.synthesize.separation.SeparationUtility;
import uniol.apt.analysis.synthesize.separation.Synthesizer;
import uniol.apt.analysis.synthesize.separation.UnsupportedPNPropertiesException;
import uniol.apt.util.DebugUtil;
import uniol.apt.util.MathTools;
import uniol.apt.util.Pair;
import uniol.apt.util.SpanningTree;
import uniol.apt.util.equations.InequalitySystem;
import uniol.apt.util.equations.InequalitySystemSolver;
import uniol.apt.util.interrupt.InterrupterRegistry;

class OutputNonbranchingSeparation
implements Separation,
Synthesizer {
    private final RegionUtility utility;
    private final TransitionSystem ts;
    private final List<ParikhVector> smallCyclesPVs = new ArrayList<ParikhVector>();
    private final List<Set<String>> cycleLabels = new ArrayList<Set<String>>();
    private final Map<State, ParikhVector> distanceCache = new HashMap<State, ParikhVector>();
    private final List<Region> regions = new ArrayList<Region>();

    public OutputNonbranchingSeparation(RegionUtility utility, PNProperties properties, String[] locationMap) throws UnsupportedPNPropertiesException {
        this.utility = utility;
        this.ts = utility.getTransitionSystem();
        PNProperties supported = new PNProperties();
        if (!supported.containsAll(properties)) {
            throw new UnsupportedPNPropertiesException();
        }
        HashSet<String> locations = new HashSet<String>(Arrays.asList(locationMap));
        locations.remove(null);
        if (locations.size() != this.ts.getAlphabet().size()) {
            throw new UnsupportedPNPropertiesException();
        }
        try {
            this.smallCyclesPVs.addAll(new CycleSearchViaChords().searchCycles(this.ts));
        }
        catch (PreconditionFailedException e) {
            throw new UnsupportedPNPropertiesException(e);
        }
        HashSet<String> remainingLabels = new HashSet<String>(this.ts.getAlphabet());
        for (ParikhVector pv : this.smallCyclesPVs) {
            int[] weights = new int[pv.getLabels().size()];
            int index = 0;
            for (String label : pv.getLabels()) {
                weights[index++] = pv.get(label);
            }
            if (MathTools.gcd(weights) != 1) {
                throw new UnsupportedPNPropertiesException("Non prime small cycle: " + pv.toString());
            }
            remainingLabels.removeAll(pv.getLabels());
            this.cycleLabels.add(pv.getLabels());
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
        }
        if (!this.checkShortPathProperty()) {
            throw new UnsupportedPNPropertiesException();
        }
        this.smallCyclesPVs.add(0, null);
        this.cycleLabels.add(0, remainingLabels);
        this.synthesis();
    }

    private boolean checkShortPathProperty() {
        SpanningTree<TransitionSystem, Arc, State> tree = this.utility.getSpanningTree();
        HashSet<State> maximalStates = new HashSet<State>(this.ts.getNodes());
        for (State state : this.ts.getNodes()) {
            State prev = tree.getPredecessor(state);
            if (prev != null) {
                maximalStates.remove(prev);
            }
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
        }
        for (State state : maximalStates) {
            ParikhVector pv = this.getDistance(state);
            for (ParikhVector smallCycle : this.smallCyclesPVs) {
                ParikhVector.Comparison comp = pv.compare(smallCycle);
                if (comp.equals((Object)ParikhVector.Comparison.EQUAL) || comp.equals((Object)ParikhVector.Comparison.GREATER_THAN)) {
                    return false;
                }
                InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            }
        }
        return true;
    }

    private ParikhVector getDistance(State state) {
        ParikhVector result = this.distanceCache.get(state);
        if (result != null) {
            return result;
        }
        SpanningTree<TransitionSystem, Arc, State> tree = this.utility.getSpanningTree();
        ArrayDeque<Pair<State, String>> pending = new ArrayDeque<Pair<State, String>>();
        State current = state;
        while (result == null) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            Arc predecessor = tree.getPredecessorEdge(current);
            if (predecessor == null) {
                result = new ParikhVector(new String[0]);
                this.distanceCache.put(current, result);
                break;
            }
            pending.addLast(new Pair<State, String>(current, predecessor.getLabel()));
            current = (State)predecessor.getSource();
            result = this.distanceCache.get(state);
        }
        while (!pending.isEmpty()) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            Pair pair = (Pair)pending.removeLast();
            result = result.add((String)pair.getSecond());
            this.distanceCache.put((State)pair.getFirst(), result);
        }
        this.distanceCache.put(state, result);
        return result;
    }

    private void synthesis() throws UnsupportedPNPropertiesException {
        Set<String> tZero = this.cycleLabels.get(0);
        for (int l = 0; l < this.cycleLabels.size(); ++l) {
            Set<String> labels = this.cycleLabels.get(l);
            HashSet<String> tZeroAndL = new HashSet<String>(labels);
            if (l != 0) {
                tZeroAndL.addAll(tZero);
            }
            for (String x : labels) {
                InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                new ComputeRegions(l, x, tZeroAndL, this.smallCyclesPVs.get(l));
            }
        }
    }

    private static void requireNonNegativeSolution(InequalitySystem system, int numVariables) {
        int[] inequality = new int[numVariables];
        for (int i = 0; i < numVariables; ++i) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            inequality[i] = 1;
            system.addInequality(0, "<=", inequality, "Variable should be non-negative");
            inequality[i] = 0;
        }
    }

    @Override
    public Region calculateSeparatingRegion(State state, State otherState) {
        for (Region region : this.regions) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            if (!SeparationUtility.isSeparatingRegion(region, state, otherState)) continue;
            return region;
        }
        assert (state.equals(otherState));
        return null;
    }

    @Override
    public Region calculateSeparatingRegion(State state, String event) {
        for (Region region : this.regions) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            if (!SeparationUtility.isSeparatingRegion(region, state, event)) continue;
            return region;
        }
        assert (SeparationUtility.isEventEnabled(state, event));
        return null;
    }

    public List<Region> getSeparatingRegions() {
        return Collections.unmodifiableList(this.regions);
    }

    @Override
    public Collection<Set<State>> getUnsolvableStateSeparationProblems() {
        return Collections.emptySet();
    }

    @Override
    public Map<String, Set<State>> getUnsolvableEventStateSeparationProblems() {
        return Collections.emptyMap();
    }

    public static class UnsolvableESSPInstanceException
    extends UnsupportedPNPropertiesException {
        public static final long serialVersionUID = 1L;
        private final State state;
        private final String event;

        private UnsolvableESSPInstanceException(State state, String event) {
            super("ESSP failure for x=" + event + " and state=" + state);
            this.state = state;
            this.event = event;
        }

        public State getState() {
            return this.state;
        }

        public String getEvent() {
            return this.event;
        }
    }

    private class ComputeRegions {
        private final int l;
        private final String x;
        private final Set<String> tZeroAndL;
        private final ParikhVector smallCycle;

        private ComputeRegions(int l, String x, Set<String> tZeroAndL, ParikhVector smallCycle) throws UnsupportedPNPropertiesException {
            this.l = l;
            this.x = x;
            this.tZeroAndL = tZeroAndL;
            this.smallCycle = smallCycle;
            HashSet<State> xnx = new HashSet<State>();
            HashSet<State> nx = new HashSet<State>();
            if (l > 0 && ((Set)OutputNonbranchingSeparation.this.cycleLabels.get(l)).size() == 1) {
                for (State state : OutputNonbranchingSeparation.this.ts.getNodes()) {
                    InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                    if (state.getPostsetEdgesByLabel(x).isEmpty()) {
                        nx.add(state);
                        continue;
                    }
                    xnx.add(state);
                }
            } else {
                for (State state : OutputNonbranchingSeparation.this.ts.getNodes()) {
                    InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                    if (!state.getPostsetEdgesByLabel(x).isEmpty()) continue;
                    nx.add(state);
                    if (state.getPresetEdgesByLabel(x).isEmpty()) continue;
                    xnx.add(state);
                }
            }
            DebugUtil.debugFormat("XNX(%s) = %s", x, xnx);
            DebugUtil.debugFormat("NX(%s) = %s", x, nx);
            Set<State> mXNX = this.computeRepresentives(xnx, true);
            DebugUtil.debugFormat("mXNX(%s) = %s", x, mXNX);
            Set<State> mNX = this.computeRepresentives(nx, false);
            DebugUtil.debugFormat("mNX(%s) = %s", x, mNX);
            for (State state : mNX) {
                this.solve(state, mXNX);
            }
        }

        private Set<State> computeRepresentives(Set<State> states, boolean maximal) {
            HashSet<State> result = new HashSet<State>();
            for (State candidate : states) {
                Iterator iter = result.iterator();
                boolean add = true;
                while (iter.hasNext()) {
                    InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                    State other = (State)iter.next();
                    if (this.isLessOrEqual(candidate, other, maximal)) {
                        add = false;
                        break;
                    }
                    if (!this.isLessOrEqual(other, candidate, maximal)) continue;
                    iter.remove();
                }
                if (!add) continue;
                result.add(candidate);
            }
            return result;
        }

        public boolean isLessOrEqual(State a, State b, boolean swap) {
            if (swap) {
                return this.isLessOrEqual(b, a);
            }
            return this.isLessOrEqual(a, b);
        }

        public boolean isLessOrEqual(State a, State b) {
            ParikhVector pva = OutputNonbranchingSeparation.this.getDistance(a);
            ParikhVector pvb = OutputNonbranchingSeparation.this.getDistance(b);
            for (String j : (Set)OutputNonbranchingSeparation.this.cycleLabels.get(0)) {
                InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                if (j.equals(this.x) || pva.get(j) <= pvb.get(j)) continue;
                return false;
            }
            if (this.l == 0) {
                return pva.get(this.x) >= pvb.get(this.x);
            }
            ParikhVector cycle = (ParikhVector)OutputNonbranchingSeparation.this.smallCyclesPVs.get(this.l);
            for (String j : (Set)OutputNonbranchingSeparation.this.cycleLabels.get(this.l)) {
                int rhs;
                int lhs;
                InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                if (j.equals(this.x) || (lhs = cycle.get(this.x) * pva.get(j) - cycle.get(j) * pva.get(this.x)) <= (rhs = cycle.get(this.x) * pvb.get(j) - cycle.get(j) * pvb.get(this.x))) continue;
                return false;
            }
            return true;
        }

        private void solve(State state, Set<State> mXNX) throws UnsupportedPNPropertiesException {
            BigInteger k;
            BigInteger factor;
            int index;
            int[] coefficients;
            ParikhVector distanceOther;
            DebugUtil.debugFormat("solve(%s, %s) called", state, mXNX);
            ArrayList<String> variables = new ArrayList<String>();
            for (String var : this.tZeroAndL) {
                InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                if (var.equals(this.x)) continue;
                variables.add(var);
            }
            InequalitySystem system = new InequalitySystem();
            OutputNonbranchingSeparation.requireNonNegativeSolution(system, 1 + variables.size());
            ParikhVector distanceState = OutputNonbranchingSeparation.this.getDistance(state);
            if (this.l == 0) {
                DebugUtil.debugFormat("Variables order will be initial marking, then %s", variables);
                for (State other : mXNX) {
                    distanceOther = OutputNonbranchingSeparation.this.getDistance(other);
                    coefficients = new int[1 + variables.size()];
                    coefficients[0] = 1 + distanceState.get(this.x) - distanceOther.get(this.x);
                    for (index = 0; index < variables.size(); ++index) {
                        InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                        String j = (String)variables.get(index);
                        coefficients[index + 1] = distanceOther.get(j) - distanceState.get(j);
                    }
                    system.addInequality(0, "<", coefficients, "Inequality for state " + other);
                }
            } else {
                DebugUtil.debugFormat("Variables order will be %s", variables);
                for (State other : mXNX) {
                    distanceOther = OutputNonbranchingSeparation.this.getDistance(other);
                    coefficients = new int[1 + variables.size()];
                    int smallCycleX = this.smallCycle.get(this.x);
                    for (int index2 = 0; index2 < variables.size(); ++index2) {
                        InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                        String j = (String)variables.get(index2);
                        coefficients[index2 + 1] = 0;
                        int n = index2 + 1;
                        coefficients[n] = coefficients[n] + this.smallCycle.get(j) * (1 + distanceState.get(this.x) - distanceOther.get(this.x));
                        int n2 = index2 + 1;
                        coefficients[n2] = coefficients[n2] - this.smallCycle.get(this.x) * (distanceState.get(j) - distanceOther.get(j));
                    }
                    system.addInequality(0, "<", coefficients, "Inequality for state " + other);
                }
            }
            List<BigInteger> solution = new InequalitySystemSolver().assertDisjunction(system).findSolution();
            DebugUtil.debugFormat("Got solution: %s", solution);
            if (solution.isEmpty()) {
                throw new UnsolvableESSPInstanceException(state, this.x);
            }
            if (this.l == 0) {
                factor = BigInteger.ONE;
                k = solution.get(0);
            } else {
                BigInteger lhs = BigInteger.ZERO;
                for (index = 0; index < variables.size(); ++index) {
                    BigInteger f = solution.get(index + 1);
                    int f2 = this.smallCycle.get((String)variables.get(index));
                    lhs = lhs.add(f.multiply(BigInteger.valueOf(f2)));
                }
                BigInteger divide = BigInteger.valueOf(this.smallCycle.get(this.x));
                BigInteger gcd = lhs.gcd(divide);
                DebugUtil.debugFormat("sum k_j * cycle[j] = %s = k * %s = k * cycle[x]", lhs, divide);
                k = lhs.divide(gcd);
                factor = divide.divide(gcd);
            }
            DebugUtil.debugFormat("Using k=%s and factor=%s", k, factor);
            BigInteger mu = null;
            for (State r : mXNX) {
                ParikhVector distance = OutputNonbranchingSeparation.this.getDistance(r);
                BigInteger value = k.multiply(BigInteger.valueOf(distance.get(this.x)));
                for (int index3 = 0; index3 < variables.size(); ++index3) {
                    InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                    BigInteger subtract = factor.multiply(solution.get(index3 + 1));
                    subtract = subtract.multiply(BigInteger.valueOf(distance.get((String)variables.get(index3))));
                    value = value.subtract(subtract);
                }
                if (mu != null && mu.compareTo(value) >= 0) continue;
                mu = value;
            }
            BigInteger h = BigInteger.ZERO;
            if (mu.compareTo(BigInteger.ZERO) < 0) {
                h = mu.negate();
                mu = BigInteger.ZERO;
            }
            DebugUtil.debugFormat("Computed h=%s (weight of side condition) and mu=%s (initial marking)", h, mu);
            Region.Builder builder = new Region.Builder(OutputNonbranchingSeparation.this.utility);
            builder.addWeightOn(this.x, k.negate());
            builder.addLoopAround(this.x, h);
            for (int index4 = 0; index4 < variables.size(); ++index4) {
                InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                builder.addWeightOn((String)variables.get(index4), factor.multiply(solution.get(index4 + 1)));
            }
            Region r = builder.withInitialMarking(mu);
            DebugUtil.debugFormat("Constructed region %s", r);
            OutputNonbranchingSeparation.this.regions.add(r);
            DebugUtil.debug();
        }
    }
}

