/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.synthesize.separation;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uniol.apt.adt.ts.Arc;
import uniol.apt.adt.ts.ParikhVector;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.cycles.CycleSearchViaChords;
import uniol.apt.analysis.exception.PreconditionFailedException;
import uniol.apt.analysis.persistent.PersistentTS;
import uniol.apt.analysis.reversible.ReversibleTS;
import uniol.apt.analysis.synthesize.PNProperties;
import uniol.apt.analysis.synthesize.Region;
import uniol.apt.analysis.synthesize.RegionUtility;
import uniol.apt.analysis.synthesize.UnreachableException;
import uniol.apt.analysis.synthesize.separation.Separation;
import uniol.apt.analysis.synthesize.separation.SeparationUtility;
import uniol.apt.analysis.synthesize.separation.Synthesizer;
import uniol.apt.analysis.synthesize.separation.UnsupportedPNPropertiesException;
import uniol.apt.util.interrupt.InterrupterRegistry;

class MarkedGraphSeparation
implements Separation,
Synthesizer {
    private final RegionUtility utility;
    private final List<Region> regions;
    private final Map<Integer, List<BigInteger>> reachedOnlyByPVs;

    public MarkedGraphSeparation(RegionUtility utility, PNProperties properties, String[] locationMap) throws UnsupportedPNPropertiesException {
        TransitionSystem ts = utility.getTransitionSystem();
        this.utility = utility;
        PNProperties supported = new PNProperties().setPure(true).setPlain(true).setTNet(true).setMarkedGraph(true).setOutputNonbranching(true);
        if (!supported.containsAll(properties)) {
            throw new UnsupportedPNPropertiesException();
        }
        try {
            for (ParikhVector pv : new CycleSearchViaChords().searchCycles(ts)) {
                for (String label : ts.getAlphabet()) {
                    if (pv.get(label) == 1) continue;
                    throw new UnsupportedPNPropertiesException("Not all small cycles satisfy P1, e.g. " + pv);
                }
            }
        }
        catch (PreconditionFailedException e) {
            throw new UnsupportedPNPropertiesException(e);
        }
        if (!new ReversibleTS(ts).isReversible()) {
            throw new UnsupportedPNPropertiesException("TS " + ts.getName() + " is not reversible");
        }
        if (!new PersistentTS(ts, true).isPersistent()) {
            throw new UnsupportedPNPropertiesException("TS " + ts.getName() + " is not backwards persistent");
        }
        this.reachedOnlyByPVs = MarkedGraphSeparation.calculateParikhVectorOfUniqueReachedState(utility);
        this.regions = this.calculateRegions();
    }

    public static Map<Integer, List<BigInteger>> calculateParikhVectorOfUniqueReachedState(RegionUtility utility) {
        HashMap<Integer, List<BigInteger>> result = new HashMap<Integer, List<BigInteger>>();
        for (State state : utility.getTransitionSystem().getNodes()) {
            List<BigInteger> pv;
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            Set<Arc> arcs = state.getPresetEdges();
            if (arcs.size() != 1) continue;
            Arc arc = arcs.iterator().next();
            int event = utility.getEventIndex(arc.getLabel());
            try {
                pv = utility.getReachingParikhVector(state);
            }
            catch (UnreachableException e) {
                continue;
            }
            List<BigInteger> old = result.put(event, pv);
            assert (old == null);
        }
        return result;
    }

    private List<Region> calculateRegions() {
        LinkedList<Region> result = new LinkedList<Region>();
        for (State state : this.utility.getTransitionSystem().getNodes()) {
            Set<Arc> following = state.getPostsetEdges();
            if (following.size() != 1 || !this.utility.getSpanningTree().isReachable(state)) continue;
            Arc arc = following.iterator().next();
            int event = this.utility.getEventIndex(arc.getLabel());
            for (Arc followingArc : ((State)arc.getTarget()).getPostsetEdges()) {
                InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                int otherEvent = this.utility.getEventIndex(followingArc.getLabel());
                if (event == otherEvent) continue;
                Object[] array = new BigInteger[this.utility.getNumberOfEvents()];
                Arrays.fill(array, BigInteger.ZERO);
                array[event] = BigInteger.ONE;
                array[otherEvent] = BigInteger.ONE.negate();
                Region.Builder builder = Region.Builder.createPure(this.utility, Arrays.asList(array));
                List<BigInteger> pv = this.reachedOnlyByPVs.get(otherEvent);
                assert (pv.contains(BigInteger.ZERO)) : pv;
                BigInteger k = Collections.max(pv);
                result.add(builder.withInitialMarking(k.subtract(pv.get(event))));
            }
        }
        return result;
    }

    @Override
    public Region calculateSeparatingRegion(State state, State otherState) {
        for (Region region : this.regions) {
            if (!SeparationUtility.isSeparatingRegion(region, state, otherState)) continue;
            return region;
        }
        assert (!this.utility.getSpanningTree().isReachable(state) || !this.utility.getSpanningTree().isReachable(otherState));
        return null;
    }

    @Override
    public Region calculateSeparatingRegion(State state, String event) {
        for (Region region : this.regions) {
            if (!SeparationUtility.isSeparatingRegion(region, state, event)) continue;
            return region;
        }
        assert (!this.utility.getSpanningTree().isReachable(state) || SeparationUtility.isEventEnabled(state, event));
        return null;
    }

    public List<Region> getSeparatingRegions() {
        return Collections.unmodifiableList(this.regions);
    }

    @Override
    public Collection<Set<State>> getUnsolvableStateSeparationProblems() {
        return Collections.emptySet();
    }

    @Override
    public Map<String, Set<State>> getUnsolvableEventStateSeparationProblems() {
        return Collections.emptyMap();
    }
}

