/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.synthesize.separation;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.commons.collections4.Bag;
import org.apache.commons.collections4.bag.HashBag;
import uniol.apt.adt.ts.Arc;
import uniol.apt.adt.ts.Event;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.synthesize.PNProperties;
import uniol.apt.analysis.synthesize.Region;
import uniol.apt.analysis.synthesize.RegionUtility;
import uniol.apt.analysis.synthesize.separation.Separation;
import uniol.apt.analysis.synthesize.separation.SeparationUtility;
import uniol.apt.analysis.synthesize.separation.UnsupportedPNPropertiesException;
import uniol.apt.analysis.totallyreachable.TotallyReachable;
import uniol.apt.util.DebugUtil;
import uniol.apt.util.MathTools;
import uniol.apt.util.Pair;
import uniol.apt.util.interrupt.InterrupterRegistry;

class KBoundedSeparation
implements Separation {
    private final RegionUtility utility;
    private final Set<Region> regions = new HashSet<Region>();
    private final boolean pure;

    KBoundedSeparation(TransitionSystem ts, PNProperties properties) throws UnsupportedPNPropertiesException {
        this(new RegionUtility(ts), properties, new String[0]);
    }

    public KBoundedSeparation(RegionUtility utility, PNProperties properties, String[] locationMap) throws UnsupportedPNPropertiesException {
        this.utility = utility;
        this.pure = properties.isPure();
        if (!properties.isKBounded()) {
            throw new UnsupportedPNPropertiesException();
        }
        PNProperties supported = new PNProperties().requireKBounded(properties.getKForKBounded()).setPure(true);
        if (!supported.containsAll(properties)) {
            throw new UnsupportedPNPropertiesException();
        }
        if (Collections.frequency(Arrays.asList(locationMap), null) != locationMap.length) {
            throw new UnsupportedPNPropertiesException();
        }
        TransitionSystem ts = utility.getTransitionSystem();
        if (!new TotallyReachable(ts).isTotallyReachable()) {
            throw new UnsupportedPNPropertiesException();
        }
        HashSet<Event> events = new HashSet<Event>();
        for (Arc arc : ts.getEdges()) {
            events.add(arc.getEvent());
        }
        if (!events.equals(ts.getAlphabetEvents())) {
            throw new UnsupportedPNPropertiesException();
        }
        if (properties.getKForKBounded() == 0) {
            return;
        }
        this.generateAllRegions(properties.getKForKBounded());
    }

    Set<Region> getRegions() {
        return Collections.unmodifiableSet(this.regions);
    }

    private void generateAllRegions(int k) {
        assert (k >= 1);
        HashSet<Bag<State>> known = new HashSet<Bag<State>>();
        LinkedList<Bag<State>> todo = new LinkedList<Bag<State>>();
        this.addExcitationAndSwitchingRegions(known);
        todo.addAll(known);
        while (!todo.isEmpty()) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            Bag r = (Bag)todo.removeFirst();
            DebugUtil.debug();
            DebugUtil.debugFormat("Examining %s", r);
            Pair<Event, Integer> event = this.findEventWithNonConstantGradient(r);
            if (event == null) {
                DebugUtil.debug("It is a region!");
                this.regions.add(this.convertToRegion(r));
                continue;
            }
            Bag<State> r1 = this.expandBelowOrEqual(r, event.getFirst(), event.getSecond());
            DebugUtil.debugFormat("for gradient(%s) <= %d, new result is %s", event.getFirst(), event.getSecond(), r1);
            if (this.shouldExplore(r1, k) && known.add(r1)) {
                todo.add(r1);
            } else {
                DebugUtil.debug("...which should not be explored");
            }
            Bag<State> r2 = this.expandAboveOrEqual(r, event.getFirst(), event.getSecond() + 1);
            DebugUtil.debugFormat("for gradient(%s) >= %d, new result is %s", event.getFirst(), event.getSecond() + 1, r2);
            if (this.shouldExplore(r2, k) && known.add(r2)) {
                todo.add(r2);
                continue;
            }
            DebugUtil.debug("...which should not be explored");
        }
        DebugUtil.debugFormat("Found the following regions: %s", this.regions);
    }

    private Bag<State> expand(Bag<State> input, Event event, int g, boolean forward) {
        TransitionSystem ts = this.utility.getTransitionSystem();
        HashBag<State> result = new HashBag<State>();
        for (State state : ts.getNodes()) {
            int increment = 0;
            for (Arc arc : forward ? state.getPostsetEdges() : state.getPresetEdges()) {
                if (!arc.getEvent().equals(event)) continue;
                int value = this.getGradient(input, arc) - g;
                if (!forward) {
                    value = -value;
                }
                if (value <= increment) continue;
                increment = value;
            }
            result.add(state, input.getCount(state) + increment);
        }
        return result;
    }

    private Bag<State> expandBelowOrEqual(Bag<State> input, Event event, int g) {
        return this.expand(input, event, g, true);
    }

    private Bag<State> expandAboveOrEqual(Bag<State> input, Event event, int g) {
        return this.expand(input, event, g, false);
    }

    private void addExcitationAndSwitchingRegions(Collection<Bag<State>> result) {
        TransitionSystem ts = this.utility.getTransitionSystem();
        for (Event event : ts.getAlphabetEvents()) {
            HashSet excitation = new HashSet();
            HashSet switching = new HashSet();
            for (Arc arc : ts.getEdges()) {
                if (!arc.getEvent().equals(event)) continue;
                excitation.add(arc.getSource());
                switching.add(arc.getTarget());
            }
            DebugUtil.debugFormat("For event %s, excitation=%s and switching=%s", event, excitation, switching);
            if (!excitation.isEmpty()) {
                result.add(new HashBag(excitation));
            }
            if (switching.isEmpty()) continue;
            result.add(new HashBag(switching));
        }
    }

    private Pair<Event, Integer> findEventWithNonConstantGradient(Bag<State> r) {
        TransitionSystem ts = this.utility.getTransitionSystem();
        HashMap<Event, Integer> gradients = new HashMap<Event, Integer>();
        Event nonConstantGradientEvent = null;
        int minGradient = Integer.MAX_VALUE;
        int maxGradient = Integer.MIN_VALUE;
        for (Arc arc : ts.getEdges()) {
            int gradient;
            if (nonConstantGradientEvent == null) {
                gradient = this.getGradient(r, arc);
                Integer old = gradients.put(arc.getEvent(), gradient);
                if (old == null || old == gradient) continue;
                nonConstantGradientEvent = arc.getEvent();
                minGradient = Math.min(gradient, old);
                maxGradient = Math.max(gradient, old);
                continue;
            }
            if (!nonConstantGradientEvent.equals(arc.getEvent())) continue;
            gradient = this.getGradient(r, arc);
            minGradient = Math.min(minGradient, gradient);
            maxGradient = Math.max(maxGradient, gradient);
        }
        if (nonConstantGradientEvent == null) {
            return null;
        }
        int average = MathTools.meanTowardsMinusInfinity(minGradient, maxGradient);
        DebugUtil.debugFormat("For %s: average %d, max gradient is %d and min gradient is %d for multiset %s", nonConstantGradientEvent, average, maxGradient, minGradient, r);
        return new Pair<Event, Integer>(nonConstantGradientEvent, average);
    }

    private int getGradient(Bag<State> r, Arc arc) {
        return r.getCount(arc.getTarget()) - r.getCount(arc.getSource());
    }

    private boolean shouldExplore(Bag<State> r, int k) {
        if (r.containsAll(this.utility.getTransitionSystem().getNodes())) {
            return false;
        }
        for (State state : r.uniqueSet()) {
            if (r.getCount(state) <= k) continue;
            return false;
        }
        return true;
    }

    private Region convertToRegion(Bag<State> r) {
        TransitionSystem ts = this.utility.getTransitionSystem();
        Region.Builder builder = new Region.Builder(this.utility);
        for (Event event : ts.getAlphabetEvents()) {
            Arc representativeArc = null;
            int minEnabledValue = Integer.MAX_VALUE;
            for (Arc arc : ts.getEdges()) {
                if (!arc.getEvent().equals(event)) continue;
                representativeArc = arc;
                minEnabledValue = Math.min(minEnabledValue, r.getCount(arc.getSource()));
            }
            assert (representativeArc != null);
            int gradient = this.getGradient(r, representativeArc);
            int forward = 0;
            int backward = 0;
            if (!this.pure) {
                backward = minEnabledValue;
                forward = minEnabledValue + gradient;
            } else if (gradient > 0) {
                forward = gradient;
            } else {
                backward = -gradient;
            }
            builder.addWeightOn(event.getLabel(), BigInteger.valueOf(-backward));
            builder.addWeightOn(event.getLabel(), BigInteger.valueOf(forward));
        }
        int initial = r.getCount(this.utility.getTransitionSystem().getInitialState());
        Region region = builder.withInitialMarking(BigInteger.valueOf(initial));
        DebugUtil.debugFormat("Region %s corresponds to %s", region, r);
        return region;
    }

    @Override
    public Region calculateSeparatingRegion(State state, State otherState) {
        for (Region region : this.regions) {
            if (!SeparationUtility.isSeparatingRegion(region, state, otherState)) continue;
            return region;
        }
        return null;
    }

    @Override
    public Region calculateSeparatingRegion(State state, String event) {
        for (Region region : this.regions) {
            if (!SeparationUtility.isSeparatingRegion(region, state, event)) continue;
            return region;
        }
        return null;
    }
}

