/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.synthesize.separation;

import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Model;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.ReasonUnknown;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import uniol.apt.adt.ts.State;
import uniol.apt.analysis.synthesize.PNProperties;
import uniol.apt.analysis.synthesize.Region;
import uniol.apt.analysis.synthesize.RegionUtility;
import uniol.apt.analysis.synthesize.UnreachableException;
import uniol.apt.analysis.synthesize.separation.SMTInterpolHelper;
import uniol.apt.analysis.synthesize.separation.Separation;
import uniol.apt.util.DebugUtil;
import uniol.apt.util.interrupt.UncheckedInterruptedException;

class InequalitySystemSeparation
implements Separation {
    private final SMTInterpolHelper helper;
    private final Script script;
    private final RegionUtility utility;
    private final PNProperties properties;
    private final Term regionInitialMarking;
    private final Term[] regionWeights;
    private final Term[] regionBackwardWeights;
    private final Term[] regionForwardWeights;

    public InequalitySystemSeparation(RegionUtility utility, PNProperties properties, String[] locationMap) {
        int numberEvents = utility.getNumberOfEvents();
        List<String> eventList = utility.getEventList();
        this.utility = utility;
        this.properties = properties;
        this.helper = new SMTInterpolHelper(utility, properties, locationMap);
        this.script = this.helper.getScript();
        Sort[] emptySort = new Sort[]{};
        this.regionWeights = new Term[numberEvents];
        this.script.declareFun("m0", emptySort, this.script.sort("Int", new Sort[0]));
        this.regionInitialMarking = this.script.term("m0", new Term[0]);
        Term[] params = new Term[1 + numberEvents + (properties.isPure() ? 0 : numberEvents)];
        params[0] = this.regionInitialMarking;
        if (properties.isPure()) {
            this.regionBackwardWeights = null;
            this.regionForwardWeights = null;
            for (int event = 0; event < eventList.size(); ++event) {
                this.script.declareFun("e-" + eventList.get(event), emptySort, this.script.sort("Int", new Sort[0]));
                this.regionWeights[event] = this.script.term("e-" + eventList.get(event), new Term[0]);
                params[1 + event] = this.regionWeights[event];
            }
        } else {
            this.regionBackwardWeights = new Term[numberEvents];
            this.regionForwardWeights = new Term[numberEvents];
            for (int event = 0; event < eventList.size(); ++event) {
                String evStr = eventList.get(event);
                this.script.declareFun("b-" + evStr, emptySort, this.script.sort("Int", new Sort[0]));
                this.script.declareFun("f-" + evStr, emptySort, this.script.sort("Int", new Sort[0]));
                this.regionBackwardWeights[event] = this.script.term("b-" + evStr, new Term[0]);
                this.regionForwardWeights[event] = this.script.term("f-" + evStr, new Term[0]);
                this.regionWeights[event] = this.script.term("-", this.script.term("f-" + evStr, new Term[0]), this.script.term("b-" + evStr, new Term[0]));
                params[1 + event] = this.regionBackwardWeights[event];
                params[1 + event + numberEvents] = this.regionForwardWeights[event];
            }
        }
        this.script.assertTerm(this.script.term("isRegion", params));
    }

    private Region regionFromSolution() {
        Region.Builder builder;
        Script.LBool isSat = this.script.checkSat();
        if (isSat == Script.LBool.UNKNOWN) {
            assert (ReasonUnknown.TIMEOUT.equals(this.script.getInfo(":reason-unknown"))) : this.script.getInfo(":reason-unknown");
            throw new UncheckedInterruptedException();
        }
        if (isSat == Script.LBool.UNSAT) {
            return null;
        }
        Model model = this.script.getModel();
        if (this.properties.isPure()) {
            ArrayList<BigInteger> weights = new ArrayList<BigInteger>();
            for (Term term : this.regionWeights) {
                weights.add(this.getValue(model, term));
            }
            builder = Region.Builder.createPure(this.utility, weights);
        } else {
            ArrayList<BigInteger> backwardWeight = new ArrayList<BigInteger>();
            ArrayList<BigInteger> forwardWeight = new ArrayList<BigInteger>();
            for (Term term : this.regionBackwardWeights) {
                backwardWeight.add(this.getValue(model, term));
            }
            for (Term term : this.regionForwardWeights) {
                forwardWeight.add(this.getValue(model, term));
            }
            builder = new Region.Builder(this.utility, backwardWeight, forwardWeight);
        }
        Region r = builder.withInitialMarking(this.getValue(model, this.regionInitialMarking));
        DebugUtil.debug((Object)"region: ", (Object)r);
        return r;
    }

    @Override
    public Region calculateSeparatingRegion(State state, State otherState) {
        if (!this.utility.getSpanningTree().isReachable(state) || !this.utility.getSpanningTree().isReachable(otherState)) {
            return null;
        }
        this.script.push(1);
        try {
            Term term1 = this.helper.evaluateReachingParikhVector(this.regionInitialMarking, this.regionWeights, state);
            Term term2 = this.helper.evaluateReachingParikhVector(this.regionInitialMarking, this.regionWeights, otherState);
            this.script.assertTerm(this.script.term("not", this.script.term("=", term1, term2)));
            Region region = this.regionFromSolution();
            return region;
        }
        catch (UnreachableException e) {
            throw new AssertionError("Made sure state is reachable, but still it isn't?!", e);
        }
        finally {
            this.script.pop(1);
        }
    }

    @Override
    public Region calculateSeparatingRegion(State state, String event) {
        if (!this.utility.getSpanningTree().isReachable(state)) {
            return null;
        }
        this.script.push(1);
        try {
            int eventIndex = this.utility.getEventIndex(event);
            Term marking = this.helper.evaluateReachingParikhVector(this.regionInitialMarking, this.regionWeights, state);
            Term term = this.properties.isPure() ? this.script.term("+", marking, this.regionWeights[eventIndex]) : this.script.term("-", marking, this.regionBackwardWeights[eventIndex]);
            this.script.assertTerm(this.script.term(">", this.script.numeral(BigInteger.ZERO), term));
            Region region = this.regionFromSolution();
            return region;
        }
        catch (UnreachableException e) {
            throw new AssertionError("Made sure state is reachable, but still it isn't?!", e);
        }
        finally {
            this.script.pop(1);
        }
    }

    private BigInteger getValue(Model model, Term term) {
        Term evald = model.evaluate(term);
        assert (evald instanceof ConstantTerm) : evald;
        Object value = ((ConstantTerm)evald).getValue();
        assert (value instanceof Rational) : value;
        Rational rat = (Rational)value;
        assert (rat.denominator().equals(BigInteger.ONE)) : value;
        return rat.numerator();
    }
}

