/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.synthesize.separation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.exception.NonDeterministicException;
import uniol.apt.analysis.factorization.SynthesisFactorisation;
import uniol.apt.analysis.synthesize.MissingLocationException;
import uniol.apt.analysis.synthesize.PNProperties;
import uniol.apt.analysis.synthesize.Region;
import uniol.apt.analysis.synthesize.RegionUtility;
import uniol.apt.analysis.synthesize.separation.SeparationUtility;
import uniol.apt.analysis.synthesize.separation.Synthesizer;

class FactorisationSynthesizer {
    private final SynthesizerFactory factory;

    public FactorisationSynthesizer() {
        this(new DefaultSynthesizerFactory());
    }

    public FactorisationSynthesizer(SynthesizerFactory factory) {
        this.factory = factory;
    }

    public Synthesizer createSynthesizer(RegionUtility utility, PNProperties properties, boolean onlyEventSeparation) throws MissingLocationException {
        Set<TransitionSystem> factors;
        try {
            factors = new SynthesisFactorisation().factorize(utility.getTransitionSystem());
        }
        catch (NonDeterministicException e) {
            return new NonDeterministicSynthesizer(e);
        }
        if (factors.size() <= 1) {
            return null;
        }
        HashSet<Region> regions = new HashSet<Region>();
        for (TransitionSystem factor : factors) {
            RegionUtility newUtility = new RegionUtility(factor);
            Synthesizer synt = this.factory.create(newUtility, properties, onlyEventSeparation);
            regions.addAll(FactorisationSynthesizer.mapRegions(synt.getSeparatingRegions(), utility));
            if (synt.getUnsolvableEventStateSeparationProblems().isEmpty() && synt.getUnsolvableStateSeparationProblems().isEmpty()) continue;
            return new FailedFactorisationSynthesizer(regions, utility.getTransitionSystem(), synt);
        }
        return new SuccessfulSynthesizer(regions);
    }

    private static Set<Region> mapRegions(Collection<Region> regions, RegionUtility utility) {
        HashSet<Region> result = new HashSet<Region>();
        for (Region region : regions) {
            result.add(Region.Builder.copyRegionToUtility(utility, region));
        }
        return result;
    }

    private static class NonDeterministicSynthesizer
    implements Synthesizer {
        private final State state1;
        private final State state2;

        public NonDeterministicSynthesizer(NonDeterministicException e) {
            Set<State> set = e.isForwardsCounterExample() ? e.getNode().getPostsetNodesByLabel(e.getLabel()) : e.getNode().getPresetNodesByLabel(e.getLabel());
            Iterator<State> it = set.iterator();
            assert (it.hasNext());
            this.state1 = it.next();
            assert (it.hasNext());
            this.state2 = it.next();
            assert (!this.state1.equals(this.state2));
        }

        @Override
        public Collection<Region> getSeparatingRegions() {
            return Collections.emptySet();
        }

        @Override
        public Map<String, Set<State>> getUnsolvableEventStateSeparationProblems() {
            return Collections.emptyMap();
        }

        @Override
        public Collection<Set<State>> getUnsolvableStateSeparationProblems() {
            HashSet<State> result = new HashSet<State>();
            result.add(this.state1);
            result.add(this.state2);
            return Collections.singleton(result);
        }
    }

    private static class FailedFactorisationSynthesizer
    implements Synthesizer {
        private final Set<Region> regions;
        private final Map<String, Set<State>> unsolvableESSP;
        private final Collection<Set<State>> unsolvableSSP;

        private FailedFactorisationSynthesizer(Set<Region> regions, TransitionSystem ts, Synthesizer failedSynthesizer) {
            this.regions = Collections.unmodifiableSet(regions);
            assert (!failedSynthesizer.getUnsolvableEventStateSeparationProblems().isEmpty() || !failedSynthesizer.getUnsolvableStateSeparationProblems().isEmpty());
            Map<String, Set<State>> map = failedSynthesizer.getUnsolvableEventStateSeparationProblems();
            if (!map.isEmpty()) {
                this.unsolvableSSP = Collections.emptySet();
                Map.Entry<String, Set<State>> entry = map.entrySet().iterator().next();
                State state = FailedFactorisationSynthesizer.mapState(entry.getValue().iterator().next(), ts);
                HashMap<String, Set<State>> result = new HashMap<String, Set<State>>();
                result.put(entry.getKey(), Collections.singleton(state));
                this.unsolvableESSP = Collections.unmodifiableMap(result);
            } else {
                this.unsolvableESSP = Collections.emptyMap();
                HashSet<State> result = new HashSet<State>();
                for (State state : failedSynthesizer.getUnsolvableStateSeparationProblems().iterator().next()) {
                    result.add(FailedFactorisationSynthesizer.mapState(state, ts));
                }
                this.unsolvableSSP = Collections.singleton(Collections.unmodifiableSet(result));
            }
        }

        private static State mapState(State state, TransitionSystem ts) {
            return ts.getNode(state.getId());
        }

        @Override
        public Collection<Region> getSeparatingRegions() {
            return this.regions;
        }

        @Override
        public Map<String, Set<State>> getUnsolvableEventStateSeparationProblems() {
            return this.unsolvableESSP;
        }

        @Override
        public Collection<Set<State>> getUnsolvableStateSeparationProblems() {
            return this.unsolvableSSP;
        }
    }

    private static class SuccessfulSynthesizer
    implements Synthesizer {
        private final Set<Region> regions;

        private SuccessfulSynthesizer(Set<Region> regions) {
            this.regions = Collections.unmodifiableSet(regions);
        }

        @Override
        public Collection<Region> getSeparatingRegions() {
            return this.regions;
        }

        @Override
        public Map<String, Set<State>> getUnsolvableEventStateSeparationProblems() {
            return Collections.emptyMap();
        }

        @Override
        public Collection<Set<State>> getUnsolvableStateSeparationProblems() {
            return Collections.emptySet();
        }
    }

    public static class DefaultSynthesizerFactory
    implements SynthesizerFactory {
        @Override
        public Synthesizer create(RegionUtility utility, PNProperties properties, boolean onlyEventSeparation) throws MissingLocationException {
            return SeparationUtility.createSynthesizerInstance(utility, properties, onlyEventSeparation, true, null, false);
        }
    }

    public static interface SynthesizerFactory {
        public Synthesizer create(RegionUtility var1, PNProperties var2, boolean var3) throws MissingLocationException;
    }
}

