/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.synthesize.separation;

import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import uniol.apt.adt.ts.Arc;
import uniol.apt.adt.ts.State;
import uniol.apt.analysis.synthesize.PNProperties;
import uniol.apt.analysis.synthesize.Region;
import uniol.apt.analysis.synthesize.RegionUtility;
import uniol.apt.analysis.synthesize.separation.Separation;
import uniol.apt.analysis.synthesize.separation.SeparationUtility;
import uniol.apt.analysis.synthesize.separation.UnsupportedPNPropertiesException;
import uniol.apt.util.DebugUtil;
import uniol.apt.util.interrupt.InterrupterRegistry;

class ElementarySeparation
implements Separation {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger MINUS_ONE = BigInteger.valueOf(-1L);
    private final RegionUtility utility;
    private final List<Set<Arc>> arcsWithLabel = new ArrayList<Set<Arc>>();
    private final boolean pure;
    private final String[] locationMap;
    private final int[] eventOrder;
    private static final String EXTENSION = StatesInRegion.class.toString() + "-index";

    public ElementarySeparation(RegionUtility utility, PNProperties properties, String[] locationMap) throws UnsupportedPNPropertiesException {
        this.utility = utility;
        this.pure = properties.isPure();
        this.locationMap = locationMap;
        PNProperties required = new PNProperties().requireSafe();
        PNProperties supported = required.setPlain(true).setPure(true);
        if (!properties.containsAll(required)) {
            throw new UnsupportedPNPropertiesException();
        }
        if (!supported.containsAll(properties)) {
            throw new UnsupportedPNPropertiesException();
        }
        if (!utility.getSpanningTree().isTotallyReachable()) {
            DebugUtil.debug("Only totally reachable transition systems are supported!");
            throw new UnsupportedPNPropertiesException();
        }
        for (int i = 0; i < utility.getNumberOfEvents(); ++i) {
            this.arcsWithLabel.add(new HashSet());
        }
        for (Arc arc : utility.getTransitionSystem().getEdges()) {
            int index = utility.getEventIndex(arc.getLabel());
            this.arcsWithLabel.get(index).add(arc);
        }
        this.eventOrder = new int[utility.getNumberOfEvents()];
        this.assignEventOrder();
    }

    private void assignEventOrder() {
        HashSet seen = new HashSet();
        ArrayDeque<State> toDo = new ArrayDeque<State>();
        HashSet<String> assigned = new HashSet<String>();
        int nextIndex = 0;
        toDo.add(this.utility.getTransitionSystem().getInitialState());
        while (!toDo.isEmpty()) {
            State state = (State)toDo.peekFirst();
            boolean found = false;
            for (Arc arc : state.getPostsetEdges()) {
                if (assigned.add(arc.getLabel())) {
                    this.eventOrder[nextIndex++] = this.utility.getEventIndex(arc.getLabel());
                }
                if (!seen.add(arc.getTarget())) continue;
                toDo.addFirst((State)arc.getTarget());
                found = true;
                break;
            }
            if (found) continue;
            State otherState = (State)toDo.removeFirst();
            assert (state == otherState);
        }
        assert (nextIndex == this.eventOrder.length);
    }

    @Override
    public Region calculateSeparatingRegion(State state, State otherState) {
        if (!this.utility.getSpanningTree().isReachable(state) || !this.utility.getSpanningTree().isReachable(otherState)) {
            return null;
        }
        RoughRegion region = new RoughRegion();
        region.setState(state, true);
        region.setState(otherState, false);
        return this.extractRegion(region);
    }

    @Override
    public Region calculateSeparatingRegion(State state, String event) {
        if (!this.utility.getSpanningTree().isReachable(state) || SeparationUtility.isEventEnabled(state, event)) {
            return null;
        }
        RoughRegion region = new RoughRegion();
        region.setState(state, false);
        region.setLabelOperation(event, Operation.EXIT);
        Region result = this.extractRegion(region);
        if (result == null && !this.pure) {
            region = new RoughRegion();
            region.setState(state, false);
            region.setLabelOperation(event, Operation.INSIDE);
            result = this.extractRegion(region);
        }
        return result;
    }

    private Region extractRegion(RoughRegion region) {
        ArrayDeque<RoughRegion> unhandled = new ArrayDeque<RoughRegion>();
        unhandled.add(region);
        while (!unhandled.isEmpty()) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            region = (RoughRegion)unhandled.remove();
            while (!region.isInconsistent() && region.refine()) {
            }
            if (region.isInconsistent()) {
                DebugUtil.debug("rough region became inconsistent, skipping it");
                continue;
            }
            String label = region.getUnassignedLabel();
            if (label == null) {
                Region result = region.extractValidRegion();
                if (result != null) {
                    DebugUtil.debug((Object)"Extracted region ", (Object)result, (Object)" from ", (Object)region);
                    return result;
                }
                DebugUtil.debug((Object)"No unassigned label found, skipping rough region ", (Object)region);
                continue;
            }
            DebugUtil.debug((Object)"Splitting the rough region on label ", (Object)label);
            RoughRegion enter = new RoughRegion(region);
            RoughRegion exit = new RoughRegion(region);
            RoughRegion inside = null;
            if (!this.pure) {
                inside = new RoughRegion(region);
            }
            if (!this.pure) {
                inside.setLabelOperation(label, Operation.INSIDE);
            }
            region.setLabelOperation(label, Operation.DONT_CROSS);
            enter.setLabelOperation(label, Operation.ENTER);
            exit.setLabelOperation(label, Operation.EXIT);
            if (!this.pure) {
                unhandled.addFirst(inside);
            }
            unhandled.addFirst(enter);
            unhandled.addFirst(exit);
            unhandled.addFirst(region);
        }
        return null;
    }

    private class StatesInRegion {
        private final State[] states;
        private final Boolean[] values;

        public StatesInRegion() {
            this.states = ElementarySeparation.this.utility.getTransitionSystem().getNodes().toArray(new State[0]);
            this.values = new Boolean[this.states.length];
            for (int i = 0; i < this.states.length; ++i) {
                this.states[i].putExtension(EXTENSION, i);
            }
        }

        public StatesInRegion(StatesInRegion other) {
            this.states = other.states;
            this.values = Arrays.copyOf(other.values, other.values.length);
        }

        private int getIndex(State key) {
            int result = (Integer)key.getExtension(EXTENSION);
            assert (key.equals(this.states[result]));
            return result;
        }

        public Boolean get(State key) {
            return this.values[this.getIndex(key)];
        }

        public Boolean put(State key, Boolean value) {
            int index = this.getIndex(key);
            Boolean old = this.values[index];
            this.values[index] = value;
            return old;
        }

        public boolean allStatesMapped() {
            return !Arrays.asList(this.values).contains(null);
        }
    }

    private class RoughRegion {
        private final StatesInRegion statesInRegion;
        private final List<Operation> labelOperations;
        private final Deque<State> statesToHandle = new ArrayDeque<State>();
        private final Deque<Integer> labelsToHandle = new ArrayDeque<Integer>();
        private String location = null;
        private boolean inconsistent = false;

        public RoughRegion() {
            this.statesInRegion = new StatesInRegion();
            this.labelOperations = new ArrayList<Object>(Collections.nCopies(ElementarySeparation.this.utility.getEventList().size(), null));
        }

        public RoughRegion(RoughRegion other) {
            this.statesInRegion = new StatesInRegion(other.statesInRegion);
            this.labelOperations = new ArrayList<Operation>(other.labelOperations);
            this.statesToHandle.addAll(other.statesToHandle);
            this.labelsToHandle.addAll(other.labelsToHandle);
            this.location = other.location;
            this.inconsistent = other.inconsistent;
        }

        public boolean isInconsistent() {
            return this.inconsistent;
        }

        public String getUnassignedLabel() {
            for (int i : ElementarySeparation.this.eventOrder) {
                if (this.labelOperations.get(i) != null) continue;
                return ElementarySeparation.this.utility.getEventList().get(i);
            }
            return null;
        }

        public void setState(State s, boolean inRegion) {
            Boolean old = this.statesInRegion.put(s, inRegion);
            if (old == null) {
                this.statesToHandle.add(s);
            } else if (old != inRegion) {
                this.inconsistent = true;
            }
        }

        public void setLabelOperation(String label, Operation op) {
            int index = ElementarySeparation.this.utility.getEventIndex(label);
            Operation oldOp = this.labelOperations.set(index, op);
            if (oldOp == null) {
                this.labelsToHandle.add(index);
            } else if (!oldOp.equals((Object)op)) {
                this.inconsistent = true;
            }
            if (op.equals((Object)Operation.EXIT) || op.equals((Object)Operation.INSIDE)) {
                String newLocation = ElementarySeparation.this.locationMap[index];
                if (this.location == null) {
                    this.location = newLocation;
                } else if (!this.location.equals(newLocation)) {
                    this.inconsistent = true;
                }
            }
        }

        public boolean refine() {
            return this.refineOnLabel() || this.refineOnState();
        }

        private boolean refineOnLabel() {
            Integer label = this.labelsToHandle.poll();
            if (label == null) {
                return false;
            }
            Operation op = this.labelOperations.get(label);
            DebugUtil.debug((Object)"Refining ", (Object)this, (Object)" on label ", (Object)ElementarySeparation.this.utility.getEventList().get(label), (Object)" with operation ", (Object)op);
            assert (op != null);
            for (Arc arc : (Set)ElementarySeparation.this.arcsWithLabel.get(label)) {
                op.refineStates(this, arc, this.statesInRegion);
            }
            return true;
        }

        private boolean refineOnState() {
            State state = this.statesToHandle.poll();
            if (state == null) {
                return false;
            }
            DebugUtil.debug((Object)"Refining ", (Object)this, (Object)" on state ", (Object)state, (Object)" which is in=", (Object)this.statesInRegion.get(state));
            for (Arc arc : state.getNeighboringEdges()) {
                Boolean sourceInRegion = this.statesInRegion.get((State)arc.getSource());
                Boolean targetInRegion = this.statesInRegion.get((State)arc.getTarget());
                if (targetInRegion == null || sourceInRegion == null) {
                    assert (targetInRegion != null || sourceInRegion != null);
                    int index = ElementarySeparation.this.utility.getEventIndex(arc.getLabel());
                    if (!Operation.DONT_CROSS.equals((Object)this.labelOperations.get(index))) continue;
                    boolean val = targetInRegion != null ? targetInRegion : sourceInRegion;
                    this.setState((State)arc.getSource(), val);
                    this.setState((State)arc.getTarget(), val);
                    continue;
                }
                if (!sourceInRegion.booleanValue() && targetInRegion.booleanValue()) {
                    this.setLabelOperation(arc.getLabel(), Operation.ENTER);
                }
                if (sourceInRegion.booleanValue() && !targetInRegion.booleanValue()) {
                    this.setLabelOperation(arc.getLabel(), Operation.EXIT);
                }
                if (ElementarySeparation.this.pure && sourceInRegion.equals(targetInRegion)) {
                    this.setLabelOperation(arc.getLabel(), Operation.DONT_CROSS);
                }
                if (ElementarySeparation.this.pure || sourceInRegion.booleanValue() || targetInRegion.booleanValue()) continue;
                this.setLabelOperation(arc.getLabel(), Operation.DONT_CROSS);
            }
            return true;
        }

        public Region extractValidRegion() {
            if (this.inconsistent) {
                return null;
            }
            if (!this.statesToHandle.isEmpty() || !this.labelsToHandle.isEmpty()) {
                return null;
            }
            if (!this.statesInRegion.allStatesMapped()) {
                return null;
            }
            if (this.labelOperations.contains(null)) {
                return null;
            }
            Region.Builder builder = new Region.Builder(ElementarySeparation.this.utility);
            for (int i = 0; i < ElementarySeparation.this.utility.getNumberOfEvents(); ++i) {
                this.labelOperations.get(i).setupRegion(builder, i);
            }
            BigInteger initialMarking = this.statesInRegion.get(ElementarySeparation.this.utility.getTransitionSystem().getInitialState()) != false ? BigInteger.ONE : BigInteger.ZERO;
            return builder.withInitialMarking(initialMarking);
        }

        public String toString() {
            HashSet<String> in = new HashSet<String>();
            HashSet<String> out = new HashSet<String>();
            for (State state : ElementarySeparation.this.utility.getTransitionSystem().getNodes()) {
                Boolean value = this.statesInRegion.get(state);
                if (Boolean.TRUE.equals(value)) {
                    in.add(state.getId());
                    continue;
                }
                if (!Boolean.FALSE.equals(value)) continue;
                out.add(state.getId());
            }
            HashSet<String> enter = new HashSet<String>();
            HashSet<String> exit = new HashSet<String>();
            HashSet<String> dontCross = new HashSet<String>();
            HashSet<String> inside = new HashSet<String>();
            for (int i = 0; i < ElementarySeparation.this.utility.getNumberOfEvents(); ++i) {
                Operation op = this.labelOperations.get(i);
                if (op == null) continue;
                String label = ElementarySeparation.this.utility.getEventList().get(i);
                op.toStringHelper(label, enter, exit, dontCross, inside);
            }
            return String.format("RoughRegion[%sin=%s, out=%s, enter=%s, exit=%s, dontCross=%s, inside=%s]", this.inconsistent ? "INCONSISTENT! " : "", in, out, enter, exit, dontCross, inside);
        }
    }

    private static enum Operation {
        ENTER{

            @Override
            public void refineStates(RoughRegion region, Arc arc, StatesInRegion statesInRegion) {
                region.setState((State)arc.getSource(), false);
                region.setState((State)arc.getTarget(), true);
            }

            @Override
            public void setupRegion(Region.Builder builder, int eventIndex) {
                builder.addWeightOn(eventIndex, ONE);
            }

            @Override
            public void toStringHelper(String entry, Set<String> enter, Set<String> exit, Set<String> dontCross, Set<String> inside) {
                enter.add(entry);
            }
        }
        ,
        EXIT{

            @Override
            public void refineStates(RoughRegion region, Arc arc, StatesInRegion statesInRegion) {
                region.setState((State)arc.getSource(), true);
                region.setState((State)arc.getTarget(), false);
            }

            @Override
            public void setupRegion(Region.Builder builder, int eventIndex) {
                builder.addWeightOn(eventIndex, MINUS_ONE);
            }

            @Override
            public void toStringHelper(String entry, Set<String> enter, Set<String> exit, Set<String> dontCross, Set<String> inside) {
                exit.add(entry);
            }
        }
        ,
        DONT_CROSS{

            @Override
            public void refineStates(RoughRegion region, Arc arc, StatesInRegion statesInRegion) {
                Boolean bool = statesInRegion.get((State)arc.getSource());
                if (bool != null) {
                    region.setState((State)arc.getTarget(), bool);
                } else {
                    bool = statesInRegion.get((State)arc.getTarget());
                    if (bool != null) {
                        region.setState((State)arc.getSource(), bool);
                    }
                }
            }

            @Override
            public void setupRegion(Region.Builder builder, int eventIndex) {
            }

            @Override
            public void toStringHelper(String entry, Set<String> enter, Set<String> exit, Set<String> dontCross, Set<String> inside) {
                dontCross.add(entry);
            }
        }
        ,
        INSIDE{

            @Override
            public void refineStates(RoughRegion region, Arc arc, StatesInRegion statesInRegion) {
                region.setState((State)arc.getSource(), true);
                region.setState((State)arc.getTarget(), true);
            }

            @Override
            public void setupRegion(Region.Builder builder, int eventIndex) {
                builder.addWeightOn(eventIndex, ONE);
                builder.addWeightOn(eventIndex, MINUS_ONE);
            }

            @Override
            public void toStringHelper(String entry, Set<String> enter, Set<String> exit, Set<String> dontCross, Set<String> inside) {
                inside.add(entry);
            }
        };


        public abstract void refineStates(RoughRegion var1, Arc var2, StatesInRegion var3);

        public abstract void setupRegion(Region.Builder var1, int var2);

        public abstract void toStringHelper(String var1, Set<String> var2, Set<String> var3, Set<String> var4, Set<String> var5);
    }
}

