/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.synthesize.separation;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import uniol.apt.adt.ts.State;
import uniol.apt.analysis.synthesize.PNProperties;
import uniol.apt.analysis.synthesize.Region;
import uniol.apt.analysis.synthesize.RegionUtility;
import uniol.apt.analysis.synthesize.UnreachableException;
import uniol.apt.analysis.synthesize.separation.Separation;
import uniol.apt.analysis.synthesize.separation.UnsupportedPNPropertiesException;
import uniol.apt.util.DebugUtil;
import uniol.apt.util.equations.InequalitySystem;
import uniol.apt.util.equations.InequalitySystemSolver;

class BasicPureSeparation
implements Separation {
    protected final RegionUtility utility;
    protected final String[] locationMap;

    protected BasicPureSeparation(RegionUtility utility, String[] locationMap) {
        this.utility = utility;
        this.locationMap = locationMap;
    }

    public BasicPureSeparation(RegionUtility utility, PNProperties properties, String[] locationMap) throws UnsupportedPNPropertiesException {
        this(utility, locationMap);
        PNProperties required = new PNProperties().setPure(true);
        if (!properties.equals(required)) {
            throw new UnsupportedPNPropertiesException();
        }
    }

    protected InequalitySystem prepareInequalitySystem() {
        return new InequalitySystem();
    }

    @Override
    public Region calculateSeparatingRegion(State state, State otherState) {
        if (!this.utility.getSpanningTree().isReachable(state) || !this.utility.getSpanningTree().isReachable(otherState)) {
            return null;
        }
        Region result = this.calculateSeparatingRegionInternal(state, otherState);
        if (result == null && this.locationMap != null) {
            result = this.calculateSeparatingRegionInternal(otherState, state);
        }
        return result;
    }

    private Region calculateSeparatingRegionInternal(State state, State otherState) {
        List<Region> basis = this.utility.getRegionBasis();
        InequalitySystem system = this.prepareInequalitySystem();
        ArrayList<BigInteger> inequality = new ArrayList<BigInteger>(basis.size());
        for (Region region : basis) {
            BigInteger otherStateValue;
            BigInteger stateValue;
            try {
                stateValue = region.getMarkingForState(state);
                otherStateValue = region.getMarkingForState(otherState);
            }
            catch (UnreachableException e) {
                throw new AssertionError("Made sure that the state is reachable, but apparently it isn't?!", e);
            }
            inequality.add(stateValue.subtract(otherStateValue));
        }
        system.addInequality(0, ">", inequality, "Region should separate state " + state + " from state " + otherState);
        DebugUtil.debug((Object)"Solving an inequality system to separate ", (Object)state, (Object)" from ", (Object)otherState, (Object)":");
        return this.findRegionFromSystem(system, basis, null);
    }

    @Override
    public Region calculateSeparatingRegion(State state, String event) {
        InequalitySystem system = this.prepareInequalitySystem();
        int eventIndex = this.utility.getEventIndex(event);
        List<Region> basis = this.utility.getRegionBasis();
        if (!this.utility.getSpanningTree().isReachable(state)) {
            return null;
        }
        block4: for (State otherState : this.utility.getTransitionSystem().getNodes()) {
            ArrayList<BigInteger> inequality = new ArrayList<BigInteger>(basis.size());
            for (Region region : basis) {
                BigInteger otherStateValue;
                BigInteger stateValue;
                try {
                    stateValue = region.getMarkingForState(state);
                }
                catch (UnreachableException e) {
                    throw new AssertionError("Made sure that the state is reachable, but apparently it isn't?!", e);
                }
                try {
                    otherStateValue = region.getMarkingForState(otherState);
                }
                catch (UnreachableException e) {
                    continue block4;
                }
                inequality.add(stateValue.subtract(otherStateValue).add(region.getWeight(eventIndex)));
            }
            system.addInequality(0, ">", inequality, "inequality for state " + otherState);
        }
        DebugUtil.debug((Object)"Solving an inequality system to separate ", (Object)state, (Object)" from ", (Object)event, (Object)":");
        return this.findRegionFromSystem(system, basis, event);
    }

    private static InequalitySystem[] requireDistributableNet(RegionUtility utility, String[] locationMap, String event) {
        Set<String> locations;
        if (event == null) {
            locations = new HashSet<String>(Arrays.asList(locationMap));
            locations.remove(null);
        } else {
            String location = locationMap[utility.getEventIndex(event)];
            if (location == null) {
                return new InequalitySystem[0];
            }
            locations = Collections.singleton(location);
        }
        InequalitySystem[] result = new InequalitySystem[locations.size()];
        int index = 0;
        for (String location : locations) {
            result[index] = new InequalitySystem();
            for (int eventIndex = 0; eventIndex < utility.getNumberOfEvents(); ++eventIndex) {
                if (locationMap[eventIndex] == null || locationMap[eventIndex].equals(location)) continue;
                ArrayList<BigInteger> inequality = new ArrayList<BigInteger>();
                for (Region region : utility.getRegionBasis()) {
                    inequality.add(region.getWeight(eventIndex));
                }
                result[index].addInequality(0, "<=", inequality, "Only events with location " + location + " may consume tokens from this region");
            }
            ++index;
        }
        return result;
    }

    protected Region findRegionFromSystem(InequalitySystem system, List<Region> basis, String event) {
        List<BigInteger> solution = new InequalitySystemSolver().assertDisjunction(system).assertDisjunction(BasicPureSeparation.requireDistributableNet(this.utility, this.locationMap, event)).findSolution();
        if (solution.isEmpty()) {
            return null;
        }
        assert (solution.size() == basis.size());
        Region.Builder builder = new Region.Builder(this.utility);
        int i = 0;
        for (Region region : basis) {
            builder.addRegionWithFactor(region, solution.get(i++));
        }
        Region result = builder.makePure().withNormalRegionInitialMarking();
        DebugUtil.debug((Object)"region: ", (Object)result);
        return result;
    }
}

