/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.synthesize.separation;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import uniol.apt.adt.ts.State;
import uniol.apt.analysis.synthesize.PNProperties;
import uniol.apt.analysis.synthesize.Region;
import uniol.apt.analysis.synthesize.RegionUtility;
import uniol.apt.analysis.synthesize.UnreachableException;
import uniol.apt.analysis.synthesize.separation.BasicPureSeparation;
import uniol.apt.analysis.synthesize.separation.Separation;
import uniol.apt.analysis.synthesize.separation.SeparationUtility;
import uniol.apt.analysis.synthesize.separation.UnsupportedPNPropertiesException;
import uniol.apt.util.DebugUtil;
import uniol.apt.util.equations.InequalitySystem;

class BasicImpureSeparation
extends BasicPureSeparation
implements Separation {
    protected BasicImpureSeparation(RegionUtility utility, String[] locationMap) {
        super(utility, locationMap);
    }

    public BasicImpureSeparation(RegionUtility utility, PNProperties properties, String[] locationMap) throws UnsupportedPNPropertiesException {
        this(utility, locationMap);
        if (!properties.equals(new PNProperties())) {
            throw new UnsupportedPNPropertiesException();
        }
    }

    @Override
    public Region calculateSeparatingRegion(State state, String event) {
        InequalitySystem system = new InequalitySystem();
        int eventIndex = this.utility.getEventIndex(event);
        List<Region> basis = this.utility.getRegionBasis();
        if (!this.utility.getSpanningTree().isReachable(state)) {
            return null;
        }
        block6: for (State otherState : this.utility.getTransitionSystem().getNodes()) {
            if (!SeparationUtility.isEventEnabled(otherState, event)) continue;
            ArrayList<BigInteger> inequality = new ArrayList<BigInteger>(basis.size());
            for (Region region : basis) {
                BigInteger otherStateValue;
                BigInteger stateValue;
                try {
                    stateValue = region.getMarkingForState(state);
                }
                catch (UnreachableException e) {
                    throw new AssertionError("Made sure that the state is reachable, but apparently it isn't?!", e);
                }
                try {
                    otherStateValue = region.getMarkingForState(otherState);
                }
                catch (UnreachableException e) {
                    continue block6;
                }
                inequality.add(stateValue.subtract(otherStateValue));
            }
            system.addInequality(0, ">", inequality, "inequality for state " + otherState);
        }
        DebugUtil.debug((Object)"Solving an inequality system to separate ", (Object)state, (Object)" from ", (Object)event, (Object)":");
        Region result = this.findRegionFromSystem(system, basis, event);
        if (result == null) {
            return null;
        }
        if (SeparationUtility.isSeparatingRegion(result, state, event)) {
            return result;
        }
        BigInteger min = null;
        for (State otherState : this.utility.getTransitionSystem().getNodes()) {
            if (!SeparationUtility.isEventEnabled(otherState, event)) continue;
            try {
                BigInteger stateMarking = result.getMarkingForState(otherState);
                if (min != null && min.compareTo(stateMarking) <= 0) continue;
                min = stateMarking;
            }
            catch (UnreachableException e) {}
        }
        if (min == null) {
            min = BigInteger.ONE;
        }
        min = min.subtract(result.getBackwardWeight(eventIndex));
        DebugUtil.debug((Object)"Adding self-loop to event ", (Object)event, (Object)" with weight ", (Object)min);
        assert (min.compareTo(BigInteger.ZERO) > 0);
        return new Region.Builder(result).addLoopAround(eventIndex, min).withInitialMarking(result.getInitialMarking());
    }
}

