/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.synthesize;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.language.Word;
import uniol.apt.analysis.synthesize.AbstractSynthesizeModule;
import uniol.apt.analysis.synthesize.SynthesizePN;
import uniol.apt.analysis.synthesize.SynthesizeUtils;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class SynthesizeWordModule
extends AbstractSynthesizeModule
implements InterruptibleModule {
    @Override
    public String getShortDescription() {
        return "Synthesize a Petri Net from a word";
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription() + ".\n\n" + SynthesizeWordModule.getOptionsDescription("cycle, ", " - cycle: Form a cyclic word representing w^* instead of solving the input word w directly\n") + "\n\nThis module tries to synthesize a Petri Net whose prefix language contains only the specified word. Thus, no other words are firable. If this fails, a list  of separation failures is printed.\n\nExample calls:\n\n apt " + this.getName() + " none a,b,a,b\n\nThe above prints a Petri net\n\n\n apt " + this.getName() + " pure,safe a,b,c,a\n\nThis also prints a Petri net\n\n\n apt " + this.getName() + " none a,b,b,a,a\n\nThe above produces the following output:\n\n separationFailurePoints: a, b, [a] b, a, a\n\nHere three places where calculated. For example, the first one of them has an initial marking of one, transition 'a' consumes a token on this place and 'b' produces one. However, these three places are not enough for producing the requested word, because after firing 'a' and 'b' once, transition 'a' is enabled, but shouldn't. The module also could not calculate any place which would prevent 'a' from occurring in this state without also restricting 'a' in some state where it must occur.\n\n\n apt " + this.getName() + " 2-bounded a,a,a\n\nThe above produces the following output:\n\n separationFailurePoints: a, a, a [a]\n\nThis means that there is no 2-bounded Petri Net where three a's are firable in sequence, but not also a fourth one can occur.";
    }

    @Override
    public String getName() {
        return "word_synthesize";
    }

    @Override
    protected void requireExtra(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("word", Word.class, "The word that should be synthesized", new String[0]);
    }

    @Override
    protected void provideExtra(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("separationFailurePoints", String.class, new String[0]);
        outputSpec.addReturnValue("stateSeparationFailurePoints", String.class, new String[0]);
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        Word word = input.getParameter("word", Word.class);
        SynthesizePN synthesize = this.runSynthesis(new TSForWord(word), input, output);
        output.setReturnValue("stateSeparationFailurePoints", String.class, SynthesizeUtils.formatSSPFailure(word, synthesize.getFailedStateSeparationProblems()));
        output.setReturnValue("separationFailurePoints", String.class, SynthesizeUtils.formatESSPFailure(word, synthesize.getFailedEventStateSeparationProblems(), false));
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.LTS};
    }

    private static class TSForWord
    implements AbstractSynthesizeModule.TransitionSystemForOptions {
        private final List<String> word;

        public TSForWord(List<String> word) {
            this.word = word;
        }

        @Override
        public Collection<String> supportedExtraOptions() {
            HashSet<String> options = new HashSet<String>();
            options.add("cyclic");
            options.add("cycle");
            return options;
        }

        @Override
        public TransitionSystem getTS(Collection<String> enabledOptions) {
            boolean cycle = enabledOptions.contains("cyclic") || enabledOptions.contains("cycle");
            return SynthesizeUtils.makeTS(this.word, cycle);
        }
    }
}

