/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.synthesize;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;

public class SynthesizeUtils {
    private SynthesizeUtils() {
    }

    private static void appendSeparationFailure(StringBuilder result, Set<String> failures, boolean compressedFormat) {
        if (failures.isEmpty()) {
            return;
        }
        boolean first = true;
        if (!compressedFormat && result.length() != 0) {
            result.append(" ");
        }
        result.append("[");
        for (String event : failures) {
            if (!compressedFormat && !first) {
                result.append(",");
            }
            result.append(event);
            first = false;
        }
        result.append("]");
    }

    /*
     * WARNING - void declaration
     */
    public static String formatESSPFailure(List<String> word, Map<String, Set<State>> separationFailures, boolean compressedFormat) {
        void var5_9;
        if (separationFailures.isEmpty()) {
            return null;
        }
        ArrayList failedSeparation = new ArrayList(word.size());
        failedSeparation.add(new HashSet());
        for (String string : word) {
            failedSeparation.add(new HashSet());
        }
        for (Map.Entry entry : separationFailures.entrySet()) {
            for (State state : (Set)entry.getValue()) {
                int index = Integer.parseInt(state.getExtension("index").toString());
                ((Set)failedSeparation.get(index)).add(entry.getKey());
            }
        }
        StringBuilder result = new StringBuilder();
        boolean bl = false;
        while (var5_9 < word.size()) {
            if (!compressedFormat && var5_9 != false) {
                result.append(",");
            }
            SynthesizeUtils.appendSeparationFailure(result, (Set)failedSeparation.get((int)var5_9), compressedFormat);
            if (!compressedFormat && result.length() != 0) {
                result.append(" ");
            }
            result.append(word.get((int)var5_9));
            ++var5_9;
        }
        SynthesizeUtils.appendSeparationFailure(result, (Set)failedSeparation.get(word.size()), compressedFormat);
        return result.toString();
    }

    public static String formatSSPFailure(List<String> word, Collection<Set<State>> separationFailures) {
        if (separationFailures.isEmpty()) {
            return null;
        }
        int[] separable = new int[word.size() + 1];
        Arrays.fill(separable, 0);
        int numFailure = 0;
        for (Set<State> states : separationFailures) {
            ++numFailure;
            for (State state : states) {
                int index = Integer.parseInt(state.getExtension("index").toString());
                separable[index] = numFailure;
            }
        }
        StringBuilder result = new StringBuilder();
        for (int index = 0; index < word.size(); ++index) {
            if (index != 0) {
                result.append(",");
            }
            if (separable[index] != 0) {
                if (index != 0) {
                    result.append(" ");
                }
                result.append(separable[index]);
            }
            if (result.length() != 0) {
                result.append(" ");
            }
            result.append(word.get(index));
        }
        if (separable[word.size()] != 0) {
            result.append(" " + separable[word.size()]);
        }
        return result.toString();
    }

    public static TransitionSystem makeTS(List<String> word) {
        return SynthesizeUtils.makeTS(word, false);
    }

    public static TransitionSystem makeTS(List<String> word, boolean cycle) {
        TransitionSystem ts = new TransitionSystem();
        State state = ts.createState();
        state.putExtension("index", 0);
        ts.setInitialState(state);
        int index = 1;
        for (String label : word) {
            State nextState;
            if (cycle && index == word.size()) {
                nextState = ts.getInitialState();
            } else {
                nextState = ts.createState();
                nextState.putExtension("index", index);
            }
            ts.createArc(state, nextState, label);
            state = nextState;
            ++index;
        }
        return ts;
    }
}

